/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.expression.snel.SnelParser;
import org.noear.solon.i18n.I18nUtil;
import org.noear.solon.validation.ValidatorException;
import org.noear.solon.validation.ValidatorFailureHandler;

public class ValidatorFailureHandlerI18n
implements ValidatorFailureHandler {
    private final SnelParser SNEL;

    public ValidatorFailureHandlerI18n(int cahceCapacity) {
        this.SNEL = new SnelParser(cahceCapacity, '#', '{');
    }

    public ValidatorFailureHandlerI18n(SnelParser snelParser) {
        Objects.requireNonNull(snelParser, "snelParser");
        this.SNEL = snelParser;
    }

    @Override
    public boolean onFailure(Context ctx, Annotation anno, Result rst, String msg) throws Throwable {
        msg = this.format(anno, rst, msg);
        throw new ValidatorException(rst.getCode(), msg, anno, rst);
    }

    public String format(Annotation anno, Result rst, String msg) {
        Context ctx;
        if (Utils.isEmpty((String)msg)) {
            if (anno != null) {
                msg = Utils.isEmpty((String)rst.getDescription()) ? new StringBuilder(100).append("@").append(anno.annotationType().getSimpleName()).append(" verification failed").toString() : new StringBuilder(100).append("@").append(anno.annotationType().getSimpleName()).append(" verification failed: ").append(rst.getDescription()).toString();
            }
        } else if (this.SNEL.hasMarker(msg) && (ctx = Context.current()) != null) {
            msg = (String)this.SNEL.forTmpl().parse(msg).eval(key -> I18nUtil.getMessage((Context)ctx, (String)key.toString()));
        }
        return msg;
    }
}

