/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Email;

public class EmailValidator
implements Validator<Email> {
    public static final String DEFAULT_PATTERN = "^[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
    private static final Map<String, Pattern> cached = new ConcurrentHashMap<String, Pattern>();
    public static final EmailValidator instance = new EmailValidator();

    public EmailValidator() {
        cached.putIfAbsent("", Pattern.compile(DEFAULT_PATTERN));
    }

    @Override
    public String message(Email anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(Email anno) {
        return anno.groups();
    }

    @Override
    public boolean isSupportValueType(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    @Override
    public Result validateOfValue(Email anno, Object val0, StringBuilder tmp) {
        if (val0 != null && !(val0 instanceof String)) {
            return Result.failure();
        }
        String val = (String)val0;
        if (!this.verify(anno, val)) {
            return Result.failure();
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Email anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (!this.verify(anno, val)) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }

    private boolean verify(Email anno, String val) {
        if (Utils.isEmpty((String)val)) {
            return true;
        }
        Pattern pt = cached.get(anno.value());
        if (pt == null) {
            if (!anno.value().contains("@")) {
                throw new IllegalArgumentException("@Email value must have an @ sign");
            }
            pt = Pattern.compile(anno.value());
            cached.putIfAbsent(anno.value(), pt);
        }
        return pt.matcher(val).find();
    }
}

