/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.auth;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.auth.AuthAdapter;
import org.noear.solon.auth.annotation.Logical;
import org.noear.solon.core.handle.Context;

public class AuthUtil {
    private static AuthAdapter adapterDef = new AuthAdapter();
    private static List<AuthAdapter> adapterList = new ArrayList<AuthAdapter>();

    public static AuthAdapter adapter() {
        if (adapterList.size() > 0) {
            Context ctx = Context.current();
            for (AuthAdapter a1 : adapterList) {
                if (!ctx.pathNew().startsWith(a1.pathPrefix())) continue;
                return a1;
            }
            throw new IllegalStateException("Unsupported auth path: " + ctx.pathNew());
        }
        return adapterDef;
    }

    public static void adapterAdd(AuthAdapter adapter) {
        if (Utils.isEmpty((String)adapter.pathPrefix())) {
            adapterDef = adapter;
        } else {
            adapterList.add(adapter);
            adapterList.sort(Comparator.comparingInt(e -> -e.pathPrefix().length()));
        }
    }

    public static void adapterRemove(AuthAdapter adapter) {
        adapterList.remove(adapter);
    }

    public static boolean verifyIp(String ip) {
        return AuthUtil.adapter().processor().verifyIp(ip);
    }

    public static boolean verifyLogined() {
        return AuthUtil.adapter().processor().verifyLogined();
    }

    public static boolean verifyPath(String path, String method) {
        return AuthUtil.adapter().processor().verifyPath(path, method);
    }

    public static boolean verifyPermissions(String ... permissions) {
        return AuthUtil.verifyPermissions(permissions, Logical.OR);
    }

    public static boolean verifyPermissionsAnd(String ... permissions) {
        return AuthUtil.verifyPermissions(permissions, Logical.AND);
    }

    public static boolean verifyPermissions(String[] permissions, Logical logical) {
        return AuthUtil.adapter().processor().verifyPermissions(permissions, logical);
    }

    public static boolean verifyRoles(String ... roles) {
        return AuthUtil.verifyRoles(roles, Logical.OR);
    }

    public static boolean verifyRolesAnd(String ... roles) {
        return AuthUtil.verifyRoles(roles, Logical.AND);
    }

    public static boolean verifyRoles(String[] roles, Logical logical) {
        return AuthUtil.adapter().processor().verifyRoles(roles, logical);
    }
}

