/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.async;

import java.util.concurrent.Future;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.aspect.MethodInterceptor;
import org.noear.solon.scheduling.annotation.Async;
import org.noear.solon.scheduling.async.AsyncExecutor;
import org.noear.solon.scheduling.async.AsyncExecutorDefault;

public class AsyncInterceptor
implements MethodInterceptor {
    private AsyncExecutor asyncExecutor = new AsyncExecutorDefault();

    public void setAsyncExecutor(AsyncExecutor asyncExecutor) {
        if (asyncExecutor != null) {
            this.asyncExecutor = asyncExecutor;
        }
    }

    public Object doIntercept(Invocation inv) throws Throwable {
        Async anno = (Async)inv.getMethodAnnotation(Async.class);
        if (anno != null) {
            Future future = this.asyncExecutor.submit(inv, anno);
            if (inv.method().getReturnType().isAssignableFrom(Future.class)) {
                return future;
            }
            return null;
        }
        return inv.invoke();
    }
}

