/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.integration;

import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.scheduling.annotation.Async;
import org.noear.solon.scheduling.annotation.Command;
import org.noear.solon.scheduling.annotation.EnableAsync;
import org.noear.solon.scheduling.annotation.EnableCommand;
import org.noear.solon.scheduling.annotation.EnableRetry;
import org.noear.solon.scheduling.annotation.Retry;
import org.noear.solon.scheduling.async.AsyncInterceptor;
import org.noear.solon.scheduling.command.CommandExecutor;
import org.noear.solon.scheduling.command.CommandExecutorProxy;
import org.noear.solon.scheduling.command.CommandManager;
import org.noear.solon.scheduling.retry.RetryInterceptor;

public class XPluginImp
implements Plugin {
    public void start(AppContext context) throws Throwable {
        EnableRetry enableRetryAnno;
        Class source = context.app().source();
        EnableAsync enableAnno = source.getAnnotation(EnableAsync.class);
        if (enableAnno != null) {
            context.beanInterceptorAdd(Async.class, (Interceptor)new AsyncInterceptor(context));
        }
        if ((enableRetryAnno = source.getAnnotation(EnableRetry.class)) != null) {
            context.beanInterceptorAdd(Retry.class, (Interceptor)new RetryInterceptor(context), Integer.MAX_VALUE);
        }
        CommandManager commandManager = CommandManager.getInstance();
        EnableCommand enableCommandAnno = source.getAnnotation(EnableCommand.class);
        if (enableCommandAnno != null) {
            context.beanBuilderAdd(Command.class, (clz, bw, anno) -> {
                if (bw.raw() instanceof CommandExecutor) {
                    CommandExecutorProxy executor = new CommandExecutorProxy(bw);
                    commandManager.register(anno.value(), executor);
                }
            });
            context.onEvent(AppLoadEndEvent.class, e -> RunUtil.delay(commandManager::executeAll, (long)100L));
        }
    }
}

