/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.scheduled.manager;

import java.lang.reflect.Method;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.scheduling.ScheduledAnno;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.scheduled.JobHandler;
import org.noear.solon.scheduling.scheduled.manager.IJobManager;
import org.noear.solon.scheduling.scheduled.proxy.JobHandlerBeanProxy;
import org.noear.solon.scheduling.scheduled.proxy.JobHandlerMethodProxy;
import org.noear.solon.scheduling.utils.ScheduledHelper;

public class JobExtractor
implements BeanBuilder<Scheduled>,
BeanExtractor<Scheduled> {
    private final IJobManager jobManager;

    public JobExtractor(IJobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void doBuild(Class<?> clz, BeanWrap bw, Scheduled anno) throws Throwable {
        String name;
        JobHandlerBeanProxy handler;
        ScheduledAnno warpper;
        if (bw.raw() instanceof Runnable || bw.raw() instanceof JobHandler) {
            warpper = new ScheduledAnno(anno);
            ScheduledHelper.configScheduled(warpper);
            handler = new JobHandlerBeanProxy(bw);
            name = warpper.name();
            if (Utils.isEmpty((String)name)) {
                name = bw.clz().getName();
            }
        } else {
            throw new IllegalStateException("Job only supports Runnable or JobHandler types!");
        }
        this.jobManager.jobAdd(name, warpper, handler);
    }

    public void doExtract(BeanWrap bw, Method method, Scheduled anno) throws Throwable {
        ScheduledAnno warpper = new ScheduledAnno(anno);
        ScheduledHelper.configScheduled(warpper);
        JobHandlerMethodProxy handler = new JobHandlerMethodProxy(bw, method);
        String name = warpper.name();
        if (Utils.isEmpty((String)name)) {
            name = bw.clz().getName() + "::" + method.getName();
        }
        this.jobManager.jobAdd(name, warpper, handler);
    }
}

