/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple;

import java.util.Map;
import org.noear.solon.scheduling.ScheduledException;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.scheduled.JobHandler;
import org.noear.solon.scheduling.scheduled.JobHolder;
import org.noear.solon.scheduling.scheduled.manager.AbstractJobManager;
import org.noear.solon.scheduling.simple.SimpleScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager
extends AbstractJobManager {
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);
    private static JobManager instance = new JobManager();

    public static JobManager getInstance() {
        return instance;
    }

    protected JobHolder jobWrapDo(String name, Scheduled scheduled, JobHandler handler) {
        JobHolder jobHolder = super.jobWrapDo(name, scheduled, handler);
        jobHolder.setAttachment((Object)new SimpleScheduler(jobHolder));
        return jobHolder;
    }

    public void jobStart(String name, Map<String, String> data) throws ScheduledException {
        JobHolder jobHolder = this.jobGet(name);
        if (jobHolder != null) {
            jobHolder.setData(data);
            try {
                ((SimpleScheduler)jobHolder.getAttachment()).start();
            }
            catch (Throwable e) {
                throw new ScheduledException(e);
            }
        }
    }

    public void jobStop(String name) throws ScheduledException {
        JobHolder jobHolder = this.jobGet(name);
        if (jobHolder != null) {
            try {
                ((SimpleScheduler)jobHolder.getAttachment()).stop();
            }
            catch (Throwable e) {
                throw new ScheduledException(e);
            }
        }
    }

    public void start() throws Throwable {
    }

    public void postStart() throws Throwable {
        for (JobHolder holder : this.jobMap.values()) {
            if (!holder.getScheduled().enable()) continue;
            ((SimpleScheduler)holder.getAttachment()).start();
        }
        this.isStarted = true;
        log.info("JobManager started, job.size={}", (Object)this.jobMap.size());
    }

    public void stop() throws Throwable {
        this.isStarted = false;
        for (JobHolder jobHolder : this.jobMap.values()) {
            ((SimpleScheduler)jobHolder.getAttachment()).stop();
        }
        log.info("JobManager stopped");
    }
}

