/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple;

import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.noear.java_cron.CronExpressionPlus;
import org.noear.java_cron.CronUtils;
import org.noear.solon.Utils;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.scheduling.scheduled.JobHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleScheduler
implements Lifecycle {
    static final Logger log = LoggerFactory.getLogger(SimpleScheduler.class);
    private JobHolder jobHolder;
    private CronExpressionPlus cron;
    private long sleepMillis;
    private Date baseTime;
    private Date nextTime;
    private ScheduledFuture<?> jobFutureOfFixed;
    private Future<?> jobFutureOfCron;
    private boolean isStarted = false;

    public SimpleScheduler(JobHolder jobHolder) {
        this.jobHolder = jobHolder;
        if (Utils.isNotEmpty((String)jobHolder.getScheduled().cron())) {
            this.cron = CronUtils.get((String)jobHolder.getScheduled().cron());
            if (Utils.isNotEmpty((String)jobHolder.getScheduled().zone())) {
                this.cron.setTimeZone(TimeZone.getTimeZone(jobHolder.getScheduled().zone()));
            }
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void start() throws Throwable {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        if (this.jobHolder.getScheduled().fixedDelay() > 0L) {
            this.jobFutureOfFixed = RunUtil.scheduleWithFixedDelay(this::exec0, (long)this.jobHolder.getScheduled().initialDelay(), (long)this.jobHolder.getScheduled().fixedDelay());
        } else if (this.jobHolder.getScheduled().fixedRate() > 0L) {
            this.jobFutureOfFixed = RunUtil.scheduleAtFixedRate(this::exec0, (long)this.jobHolder.getScheduled().initialDelay(), (long)this.jobHolder.getScheduled().fixedRate());
        } else {
            RunUtil.parallel(this::run);
        }
    }

    public void stop() throws Throwable {
        this.isStarted = false;
        if (false) {
            return;
        }
        this.isStarted = false;
        if (this.jobFutureOfFixed != null) {
            this.jobFutureOfFixed.cancel(false);
        }
        if (this.jobFutureOfCron != null) {
            this.jobFutureOfCron.cancel(false);
        }
    }

    private void run() {
        if (this.baseTime == null) {
            this.baseTime = new Date();
        }
        if (!this.isStarted) {
            return;
        }
        try {
            this.runAsCron();
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            if (e instanceof InterruptedException) {
                this.isStarted = false;
                return;
            }
            log.warn(e.getMessage(), e);
        }
        if (this.sleepMillis < 0L) {
            this.sleepMillis = 100L;
        }
        RunUtil.delay(this::run, (long)this.sleepMillis);
    }

    private void runAsCron() throws Throwable {
        this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
        if (this.nextTime != null) {
            this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
            if (this.sleepMillis >= 0L) {
                if (this.sleepMillis <= 1000L) {
                    this.jobFutureOfCron = RunUtil.parallel(this::exec0);
                }
                this.baseTime = this.nextTime;
                this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
                if (this.nextTime != null && this.sleepMillis <= 1000L) {
                    this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
                }
            }
        }
        if (this.nextTime == null) {
            this.isStarted = false;
            log.warn("The cron expression has expired, and the job is complete!");
        }
    }

    private void exec0() {
        try {
            this.jobHolder.handle(null);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

