/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.rx.impl;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.noear.solon.rx.Completable;
import org.noear.solon.rx.CompletableEmitter;
import org.noear.solon.rx.SimpleSubscriber;
import org.noear.solon.rx.impl.CompletableEmitterImpl;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class CompletableImpl
implements Completable,
Subscription {
    private final Throwable cause;
    private volatile Consumer<CompletableEmitter> emitterConsumer;
    private volatile boolean subscribed = false;
    private volatile boolean cancelled = false;

    public CompletableImpl(Throwable cause, Consumer<CompletableEmitter> emitterConsumer) {
        this.cause = cause;
        this.emitterConsumer = emitterConsumer;
    }

    public void subscribe(Subscriber<? super Void> subscriber) {
        if (subscriber == null) {
            throw new IllegalArgumentException("Subscriber cannot be null");
        }
        if (this.cancelled) {
            throw new IllegalStateException("Completable has been cancelled");
        }
        if (this.subscribed) {
            throw new IllegalStateException("Completable can only be subscribed once");
        }
        this.subscribed = true;
        subscriber.onSubscribe((Subscription)this);
        if (this.emitterConsumer == null) {
            if (this.cause == null) {
                subscriber.onComplete();
            } else {
                subscriber.onError(this.cause);
            }
        } else {
            this.emitterConsumer.accept(new CompletableEmitterImpl(subscriber));
        }
    }

    public void request(long l) {
    }

    public void cancel() {
        this.cancelled = true;
        this.emitterConsumer = null;
    }

    @Override
    public Completable doOnError(final Consumer<Throwable> doOnError) {
        if (doOnError == null) {
            throw new IllegalArgumentException("doOnError consumer cannot be null");
        }
        return Completable.create(emitter -> this.subscribe((Subscriber<? super Void>)new SimpleSubscriber<Void>(){

            @Override
            public void onError(Throwable err) {
                try {
                    doOnError.accept(err);
                }
                finally {
                    emitter.onError(err);
                }
            }

            @Override
            public void onComplete() {
                emitter.onComplete();
            }
        }));
    }

    @Override
    public Completable doOnErrorResume(final Function<Throwable, Completable> doOnError) {
        if (doOnError == null) {
            throw new IllegalArgumentException("doOnErrorResume function cannot be null");
        }
        return Completable.create(emitter -> this.subscribe((Subscriber<? super Void>)new SimpleSubscriber<Void>(){

            @Override
            public void onError(Throwable err) {
                try {
                    Completable resumed = (Completable)doOnError.apply(err);
                    if (resumed == null) {
                        emitter.onError(err);
                    } else {
                        resumed.subscribe(new SimpleSubscriber<Void>(){

                            @Override
                            public void onComplete() {
                                emitter.onComplete();
                            }

                            @Override
                            public void onError(Throwable err2) {
                                emitter.onError(err2);
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    emitter.onError(t);
                }
            }

            @Override
            public void onComplete() {
                emitter.onComplete();
            }
        }));
    }

    @Override
    public Completable doOnComplete(final Runnable doOnComplete) {
        if (doOnComplete == null) {
            throw new IllegalArgumentException("doOnComplete runnable cannot be null");
        }
        return Completable.create(emitter -> this.subscribe((Subscriber<? super Void>)new SimpleSubscriber<Void>(){

            @Override
            public void onError(Throwable err) {
                emitter.onError(err);
            }

            @Override
            public void onComplete() {
                try {
                    doOnComplete.run();
                }
                finally {
                    emitter.onComplete();
                }
            }
        }));
    }

    @Override
    public Completable then(final Supplier<Completable> otherSupplier) {
        if (otherSupplier == null) {
            throw new IllegalArgumentException("otherSupplier cannot be null");
        }
        return Completable.create(emitter -> this.subscribe((Subscriber<? super Void>)new SimpleSubscriber<Void>(){

            @Override
            public void onError(Throwable err) {
                emitter.onError(err);
            }

            @Override
            public void onComplete() {
                try {
                    Completable other = (Completable)otherSupplier.get();
                    if (other == null) {
                        emitter.onComplete();
                    } else {
                        other.subscribe(new SimpleSubscriber<Void>(){

                            @Override
                            public void onComplete() {
                                emitter.onComplete();
                            }

                            @Override
                            public void onError(Throwable err2) {
                                emitter.onError(err2);
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    emitter.onError(t);
                }
            }
        }));
    }

    @Override
    public void subscribe() {
        this.subscribe(new SimpleSubscriber());
    }

    @Override
    public void subscribe(final CompletableEmitter emitter) {
        this.subscribe((Subscriber<? super Void>)new SimpleSubscriber<Void>(){

            @Override
            public void onError(Throwable err) {
                emitter.onError(err);
            }

            @Override
            public void onComplete() {
                emitter.onComplete();
            }
        });
    }
}

