/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.proxy.BeanProxy;
import org.noear.solon.proxy.aot.AotProxy;
import org.noear.solon.proxy.asm.AsmProxy;

public class ProxyUtil {
    public static <T> T newProxyInstance(BeanWrap bw) {
        if (bw.proxy() == null) {
            bw.proxySet((BeanWrap.Proxy)BeanProxy.getGlobal());
        }
        return (T)bw.get();
    }

    public static <T> T newProxyInstance(Class<T> clazz, InvocationHandler handler) {
        return ProxyUtil.newProxyInstance(Solon.context(), clazz, handler);
    }

    public static <T> T newProxyInstance(AppContext context, Class<T> clazz, InvocationHandler handler) {
        assert (context != null);
        assert (clazz != null);
        if (clazz.isInterface()) {
            return (T)Proxy.newProxyInstance(context.getClassLoader(), new Class[]{clazz}, handler);
        }
        Object proxy = null;
        if (NativeDetector.isNotAotRuntime()) {
            proxy = AotProxy.newProxyInstance(context, handler, clazz, new Object[0]);
        }
        if (proxy == null) {
            proxy = AsmProxy.newProxyInstance(context, handler, clazz, null, new Object[0]);
        }
        return (T)proxy;
    }
}

