/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.solon.integration;

import com.github.xiaoymin.knife4j.solon.extension.OpenApiExtensionResolver;
import com.github.xiaoymin.knife4j.solon.integration.Knife4jController;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.docs.BasicAuth;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.web.staticfiles.StaticMappings;
import org.noear.solon.web.staticfiles.StaticRepository;
import org.noear.solon.web.staticfiles.repository.ClassPathStaticRepository;

public class Knife4jPlugin
implements Plugin {
    public void start(AppContext context) throws Throwable {
        OpenApiExtensionResolver openApiExtensionResolver = (OpenApiExtensionResolver)context.wrapAndPut(OpenApiExtensionResolver.class).get();
        if (openApiExtensionResolver.getSetting().isEnable()) {
            String uiPath = "/";
            if (openApiExtensionResolver.getSetting().isProduction()) {
                if (!context.app().cfg().isFilesMode()) {
                    StaticMappings.add((String)uiPath, (StaticRepository)new ClassPathStaticRepository("META-INF/resources"));
                }
            } else {
                StaticMappings.add((String)uiPath, (StaticRepository)new ClassPathStaticRepository("META-INF/resources"));
            }
            context.app().add(uiPath, Knife4jController.class);
            context.subBeansOfType(DocDocket.class, bean -> {
                if (Utils.isEmpty((Map)bean.basicAuth())) {
                    bean.basicAuth((BasicAuth)openApiExtensionResolver.getSetting().getBasic());
                }
                bean.vendorExtensions(openApiExtensionResolver.buildExtensions());
            });
        }
    }
}

