/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.solon.extension;

import com.github.xiaoymin.knife4j.solon.extension.OpenApiExtension;
import com.github.xiaoymin.knife4j.solon.extension.OpenApiSettingExtension;
import com.github.xiaoymin.knife4j.solon.settings.OpenApiExtendSetting;
import com.github.xiaoymin.knife4j.solon.settings.OpenApiSetting;
import java.util.Arrays;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.models.ApiVendorExtension;

public class OpenApiExtensionResolver {
    private final OpenApiSetting setting;
    private final OpenApiExtendSetting extendSetting;
    private final OpenApiExtension extension = new OpenApiExtension();

    public OpenApiExtensionResolver() {
        this.setting = (OpenApiSetting)Solon.cfg().getBean("knife4j", OpenApiSetting.class);
        this.extendSetting = (OpenApiExtendSetting)Solon.cfg().getBean("knife4j.setting", OpenApiExtendSetting.class);
        this.extension.addProperty(new OpenApiSettingExtension(this.extendSetting));
    }

    public OpenApiSetting getSetting() {
        return this.setting;
    }

    public OpenApiExtendSetting getExtendSetting() {
        return this.extendSetting;
    }

    public List<ApiVendorExtension> buildExtensions() {
        return Arrays.asList(this.extension);
    }

    public void buildExtensions(DocDocket docket) {
        if (this.setting.getBasic().isEnable()) {
            docket.basicAuth(this.setting.getBasic().getUsername(), this.setting.getBasic().getPassword());
        }
        docket.vendorExtensions(this.extension.getName(), (Object)this.extension.getValue());
    }
}

