/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;
import org.noear.solon.net.websocket.listener.ExpressWebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathWebSocketListener
implements WebSocketListener {
    static final Logger log = LoggerFactory.getLogger(PathWebSocketListener.class);
    private final RoutingTable<WebSocketListener> routingTable = new RoutingTableDefault();
    private final boolean autoClose;

    public PathWebSocketListener() {
        this(false);
    }

    public PathWebSocketListener(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public int count() {
        return this.routingTable.count();
    }

    public PathWebSocketListener of(String path, int index, WebSocketListener listener) {
        ExpressWebSocketListener lh = new ExpressWebSocketListener(path, listener);
        this.routingTable.add(path, MethodType.SOCKET, index, null, (Object)lh);
        return this;
    }

    public PathWebSocketListener of(String path, WebSocketListener listener) {
        return this.of(path, 0, listener);
    }

    public PathWebSocketListener remove(String path) {
        this.routingTable.remove(path);
        return this;
    }

    public WebSocketListener matching(WebSocket s) {
        if (s == null) {
            return null;
        }
        String path = s.path();
        return this.matching(path);
    }

    public WebSocketListener matching(String path) {
        if (path == null) {
            return null;
        }
        return (WebSocketListener)this.routingTable.matchOne(path, "", MethodType.SOCKET);
    }

    @Override
    public void onOpen(WebSocket s) {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onOpen(s);
        } else if (this.autoClose) {
            s.close();
            log.warn("Route failed. The connection will close. path={}", (Object)s.path());
        }
    }

    @Override
    public void onMessage(WebSocket s, String text) throws IOException {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onMessage(s, text);
        }
    }

    @Override
    public void onMessage(WebSocket s, ByteBuffer binary) throws IOException {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onMessage(s, binary);
        }
    }

    @Override
    public void onClose(WebSocket s) {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onClose(s);
        }
    }

    @Override
    public void onError(WebSocket s, Throwable error) {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onError(s, error);
        }
    }

    @Override
    public void onPing(WebSocket s) {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onPing(s);
        }
    }

    @Override
    public void onPong(WebSocket s) {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onPong(s);
        }
    }
}

