/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketBase;
import org.noear.solon.net.websocket.WebSocketRouter;

public abstract class WebSocketTimeoutBase
extends WebSocketBase {
    private long idleTimeout;
    private ScheduledFuture<?> idleTimeoutFuture;
    private long liveTime;
    private final ReentrantLock SYNC_LOCK = new ReentrantLock(true);

    public void onSend() {
        this.liveTime = System.currentTimeMillis();
    }

    public void onReceive() {
        this.liveTime = System.currentTimeMillis();
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.liveTime = System.currentTimeMillis();
        this.checkIdleTimeoutFuture();
    }

    private void checkIdleTimeoutFuture() {
        this.SYNC_LOCK.lock();
        try {
            if (this.idleTimeout > 0L) {
                if (this.liveTime + this.idleTimeout < System.currentTimeMillis() && this.isValid()) {
                    if (log.isDebugEnabled()) {
                        log.debug("WebSocket idle timeout, will close!");
                    }
                    RunUtil.runAndTry(this::close);
                    WebSocketRouter.getInstance().getListener().onClose(this);
                    return;
                }
                if (this.idleTimeoutFuture != null) {
                    this.idleTimeoutFuture.cancel(true);
                }
                this.idleTimeoutFuture = RunUtil.delay(this::checkIdleTimeoutFuture, (long)this.idleTimeout);
            } else if (this.idleTimeoutFuture != null) {
                this.idleTimeoutFuture.cancel(true);
                this.idleTimeoutFuture = null;
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }
}

