/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.broker;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.lang.Nullable;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.broker.impl.StompBrokerMedia;
import org.noear.solon.net.stomp.broker.impl.StompSessionImpl;
import org.noear.solon.net.stomp.listener.StompListener;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToStompWebSocketListener
implements WebSocketListener,
SubProtocolCapable {
    static final Logger log = LoggerFactory.getLogger(ToStompWebSocketListener.class);
    private final StompBrokerMedia brokerMedia;

    protected ToStompWebSocketListener(String endpoint, StompBrokerMedia brokerMedia) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint is not empty");
        }
        this.brokerMedia = brokerMedia;
    }

    public String getSubProtocols(@Nullable Collection<String> requestProtocols) {
        if (Utils.isEmpty(requestProtocols)) {
            return null;
        }
        return "stomp";
    }

    public void onOpen(WebSocket socket) {
        StompSessionImpl session = StompSessionImpl.of(socket);
        for (RankEntity<StompListener> listener : this.brokerMedia.listeners) {
            ((StompListener)listener.target).onOpen(session);
        }
    }

    public void onMessage(WebSocket socket, ByteBuffer binary) throws IOException {
        String txt = Charset.forName("UTF-8").decode(binary).toString();
        this.onMessage(socket, txt);
    }

    public void onMessage(WebSocket socket, String text) throws IOException {
        StompSessionImpl session = StompSessionImpl.of(socket);
        AtomicBoolean decodeOk = new AtomicBoolean(Boolean.FALSE);
        StompBrokerMedia.codec.decode(text, frame -> {
            decodeOk.set(Boolean.TRUE);
            this.onStomp(session, (Frame)frame);
            session.receipt((Frame)frame);
        });
        if (!decodeOk.get()) {
            if (log.isDebugEnabled()) {
                log.debug("Session ping, {}", (Object)socket.id());
            }
            session.send(Frame.newBuilder().command("MESSAGE").payload(text).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(WebSocket socket) {
        try {
            StompSessionImpl session = StompSessionImpl.of(socket);
            for (RankEntity<StompListener> listener : this.brokerMedia.listeners) {
                ((StompListener)listener.target).onClose(session);
            }
        }
        finally {
            socket.attrMap().clear();
        }
    }

    public void onError(WebSocket socket, Throwable error) {
        StompSessionImpl session = StompSessionImpl.of(socket);
        for (RankEntity<StompListener> listener : this.brokerMedia.listeners) {
            try {
                ((StompListener)listener.target).onError(session, error);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onStomp(StompSessionImpl session, Frame frame) {
        String txId = frame.getHeader("transaction");
        if ("BEGIN".equals(frame.getCommand())) {
            String txAttrKey = "transaction:" + txId;
            session.getSocket().attr(txAttrKey, new ArrayList());
            return;
        } else if ("COMMIT".equals(frame.getCommand())) {
            String txAttrKey = "transaction:" + txId;
            List frameList = (List)session.getSocket().attr(txAttrKey);
            try {
                if (frameList == null || frameList.size() <= 0) return;
                for (Frame f : frameList) {
                    this.stompToListener(session, f);
                }
                return;
            }
            finally {
                session.getSocket().attrMap().remove(txAttrKey);
            }
        } else if ("ABORT".equals(frame.getCommand())) {
            String txAttrKey = "transaction:" + txId;
            session.getSocket().attrMap().remove(txAttrKey);
            return;
        } else if (txId != null) {
            String txAttrKey = "transaction:" + txId;
            List frameList = (List)session.getSocket().attrMap().computeIfAbsent(txAttrKey, k -> new ArrayList());
            frameList.add(frame);
            return;
        } else {
            this.stompToListener(session, frame);
        }
    }

    protected void stompToListener(StompSessionImpl session, Frame frame) {
        for (RankEntity<StompListener> listener : this.brokerMedia.listeners) {
            try {
                ((StompListener)listener.target).onFrame(session, frame);
            }
            catch (Throwable e) {
                this.onError(session.getSocket(), e);
            }
        }
    }
}

