/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.broker.impl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.StompSession;
import org.noear.solon.net.stomp.broker.impl.StompBrokerMedia;
import org.noear.solon.net.stomp.broker.impl.Subscription;
import org.noear.solon.net.websocket.WebSocket;

public class StompSessionImpl
implements StompSession {
    private final WebSocket socket;
    private final Set<Subscription> subscriptions = Collections.newSetFromMap(new ConcurrentHashMap());

    public static StompSessionImpl of(WebSocket socket) {
        StompSessionImpl tmp = (StompSessionImpl)socket.attr("SESSION");
        if (tmp == null) {
            tmp = new StompSessionImpl(socket);
            socket.attr("SESSION", (Object)tmp);
        }
        return tmp;
    }

    private StompSessionImpl(WebSocket socket) {
        this.socket = socket;
    }

    public WebSocket getSocket() {
        return this.socket;
    }

    @Override
    public String id() {
        return this.socket.id();
    }

    @Override
    public String name() {
        return this.socket.name();
    }

    @Override
    public void nameAs(String name) {
        this.socket.nameAs(name);
    }

    @Override
    public String param(String name) {
        return this.socket.param(name);
    }

    @Override
    public String paramOrDefault(String name, String def) {
        return this.socket.paramOrDefault(name, def);
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.socket.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.socket.localAddress();
    }

    @Override
    public void close() {
        this.socket.close();
    }

    public void addSubscription(Subscription subscription) {
        this.subscriptions.add(subscription);
    }

    public Subscription getSubscription(String destination) {
        for (Subscription sub : this.subscriptions) {
            if (!sub.matches(destination)) continue;
            return sub;
        }
        return null;
    }

    @Override
    public void send(Frame frame) {
        assert (frame != null);
        if (this.socket.isValid()) {
            String frameStr = StompBrokerMedia.codec.encode(frame);
            this.socket.send(ByteBuffer.wrap(frameStr.getBytes(StandardCharsets.UTF_8)));
        }
    }

    public void receipt(Frame frame) {
        String receiptId = frame.getHeader("receipt");
        if (receiptId != null) {
            Frame frame1 = Frame.newBuilder().command("RECEIPT").headerAdd("receipt-id", receiptId).build();
            this.send(frame1);
        }
    }
}

