/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextUtil;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.StompSession;
import org.noear.solon.net.stomp.broker.StompBroker;
import org.noear.solon.net.stomp.handle.StompContext;
import org.noear.solon.net.stomp.listener.SimpleStompListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToHandlerStompListener
extends SimpleStompListener {
    private static final Logger log = LoggerFactory.getLogger(ToHandlerStompListener.class);
    private final StompBroker broker;

    public ToHandlerStompListener(StompBroker broker) {
        this.broker = broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(StompSession session, Frame frame) throws Throwable {
        if ("SEND".equals(frame.getCommand())) {
            String destination = frame.getHeader("destination");
            if (Utils.isEmpty((String)destination)) {
                log.warn("This stomp message is missing route, source={}", (Object)frame.getSource());
            } else {
                StompContext ctx = new StompContext(session, frame, destination, this.broker.getEmitter());
                Handler handler = Solon.app().router().matchMain((Context)ctx);
                if (handler != null) {
                    try {
                        ContextUtil.currentSet((Context)ctx);
                        handler.handle((Context)ctx);
                        if (!ctx.asyncStarted()) {
                            ctx.innerCommit();
                        }
                    }
                    finally {
                        ContextUtil.currentRemove();
                    }
                }
            }
        }
    }
}

