/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.noear.solon.Utils;
import org.noear.solon.annotation.To;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompEmitter;
import org.noear.solon.net.websocket.WebSocket;

public class StompContext
extends ContextEmpty {
    private WebSocket socket;
    private Frame frame;
    private String destination;
    private StompEmitter emitter;
    private InputStream bodyAsStream;

    public StompContext(WebSocket socket, Frame frame, String destination, StompEmitter emitter) {
        this.socket = socket;
        this.frame = frame;
        this.destination = destination;
        this.emitter = emitter;
    }

    public Frame frame() {
        return this.frame;
    }

    public StompEmitter emitter() {
        return this.emitter;
    }

    public Object request() {
        return this.socket;
    }

    public String remoteIp() {
        try {
            return this.socket.remoteAddress().getAddress().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int remotePort() {
        try {
            return this.socket.remoteAddress().getPort();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isMultipart() {
        return false;
    }

    public String sessionId() {
        return this.socket.id();
    }

    public String method() {
        return MethodType.MESSAGE.name;
    }

    public String path() {
        return this.destination;
    }

    public String contentType() {
        return this.frame.getHeader("content-type");
    }

    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream == null) {
            this.bodyAsStream = new ByteArrayInputStream(this.frame.getPayload().getBytes(StandardCharsets.UTF_8));
        }
        return this.bodyAsStream;
    }

    public String body(String charset) throws IOException {
        return this.frame.getPayload();
    }

    public MultiMap<String> headerMap() {
        if (this.headerMap == null) {
            this.headerMap = this.frame.getHeaderAll();
        }
        return this.headerMap;
    }

    public Object response() {
        return this.socket;
    }

    public void contentType(String contentType) {
        this.headerSet("content-type", contentType);
    }

    public Object pull(Class<?> clz) {
        if (Frame.class.isAssignableFrom(clz)) {
            return this.frame;
        }
        if (WebSocket.class.isAssignableFrom(clz)) {
            return this.socket;
        }
        return null;
    }

    public void commit() throws Throwable {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)this.outputStream();
        if (baos.size() > 0) {
            String returnValue = new String(baos.toByteArray());
            this.commit(returnValue);
        }
    }

    public void commit(Object returnValue) throws Throwable {
        Message message = returnValue instanceof Message ? (Message)returnValue : (returnValue instanceof String ? new Message((String)returnValue) : new Message(this.renderAndReturn(returnValue)));
        message.headers((Iterable<KeyValues<String>>)this.headerMap());
        Action action = this.action();
        Object anno = null;
        if (action != null) {
            action.method().getAnnotation(To.class);
        }
        if (anno == null) {
            this.emitter().sendTo(this.path(), message);
        } else {
            for (String destination : anno.value()) {
                if (Utils.isEmpty((String)destination)) {
                    this.emitter().sendTo(this.path(), message);
                    continue;
                }
                this.emitter().sendTo(destination, message);
            }
        }
    }
}

