/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.broker.impl;

import java.util.Iterator;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.broker.impl.StompServerEmitter;
import org.noear.solon.net.stomp.broker.impl.StompServerOperations;
import org.noear.solon.net.stomp.broker.impl.SubscriptionInfo;
import org.noear.solon.net.stomp.listener.StompListener;
import org.noear.solon.net.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompServerOperationsListener
implements StompListener {
    static Logger log = LoggerFactory.getLogger(StompServerOperationsListener.class);
    private final StompServerEmitter emitter;
    private final StompServerOperations operations;

    protected StompServerOperationsListener(StompServerOperations operations, StompServerEmitter emitter) {
        this.emitter = emitter;
        this.operations = operations;
    }

    @Override
    public void onOpen(WebSocket socket) {
        this.operations.getSessionMap().put(socket.id(), socket);
    }

    @Override
    public void onFrame(WebSocket socket, Frame frame) {
        switch (frame.getCommand()) {
            case "STOMP": 
            case "CONNECT": {
                this.onConnect(socket, frame);
                break;
            }
            case "DISCONNECT": {
                this.onDisconnect(socket, frame);
                break;
            }
            case "SUBSCRIBE": {
                this.onSubscribe(socket, frame);
                break;
            }
            case "UNSUBSCRIBE": {
                this.onUnsubscribe(socket, frame);
                break;
            }
            case "SEND": {
                this.onSend(socket, frame);
                break;
            }
            case "ACK": 
            case "NACK": {
                this.onAck(socket, frame);
                break;
            }
            default: {
                log.warn("Frame unknown, {}\r\n{}", (Object)socket.id(), (Object)frame.getSource());
                this.emitter.sendTo(socket, Frame.newBuilder().command("UNKNOWN").payload(frame.getSource()).build());
            }
        }
    }

    @Override
    public void onClose(WebSocket socket) {
        this.operations.getSessionMap().remove(socket);
        this.onUnsubscribe(socket, null);
    }

    @Override
    public void onError(WebSocket socket, Throwable error) {
    }

    public void onConnect(WebSocket socket, Frame frame) {
        String heartBeat = frame.getHeader("heart-beat");
        Frame frame1 = Frame.newBuilder().command("CONNECTED").headers(new KeyValue("heart-beat", (Object)(heartBeat == null ? "0,0" : heartBeat)), new KeyValue("server", (Object)"stomp"), new KeyValue("version", (Object)"1.2")).build();
        this.emitter.sendTo(socket, frame1);
    }

    public void onDisconnect(WebSocket socket, Frame frame) {
        String receiptId = frame.getHeader("receipt");
        Frame frame1 = Frame.newBuilder().command("RECEIPT").header("receipt-id", receiptId).build();
        this.emitter.sendTo(socket, frame1);
    }

    public void onSubscribe(WebSocket socket, Frame frame) {
        String receiptId;
        String subscriptionId = frame.getHeader("id");
        String destination = frame.getHeader("destination");
        if (destination == null || destination.length() == 0 || subscriptionId == null || subscriptionId.length() == 0) {
            Frame frame1 = Frame.newBuilder().command("ERROR").payload("Required 'destination' or 'id' header missed").build();
            this.emitter.sendTo(socket, frame1);
            return;
        }
        SubscriptionInfo destinationInfo = new SubscriptionInfo(socket.id(), destination, subscriptionId);
        this.operations.getSubscriptionInfos().add(destinationInfo);
        if (!this.operations.getDestinationMatchs().containsKey(destination)) {
            String destinationRegexp = "^" + destination.replaceAll("\\*\\*", ".+").replaceAll("\\*", "[^/]+") + "$";
            this.operations.getDestinationMatchs().put(destination, Pattern.compile(destinationRegexp));
        }
        if ((receiptId = frame.getHeader("receipt")) != null) {
            Frame frame1 = Frame.newBuilder().command("RECEIPT").header("receipt-id", receiptId).build();
            this.emitter.sendTo(socket, frame1);
        }
    }

    public void onUnsubscribe(WebSocket socket, Frame frame) {
        String sessionId = socket.id();
        if (frame == null) {
            this.unSubscribeHandle(destinationInfo -> sessionId.equals(destinationInfo.getSessionId()));
        } else {
            String subscriptionId = frame.getHeader("id");
            String destination = frame.getHeader("destination");
            this.unSubscribeHandle(destinationInfo -> sessionId.equals(destinationInfo.getSessionId()) && (destinationInfo.getDestination().equals(destination) || destinationInfo.getSubscriptionId().equals(subscriptionId)));
        }
    }

    public void onSend(WebSocket socket, Frame frame) {
        String destination = frame.getHeader("destination");
        if (Utils.isEmpty((String)destination)) {
            Frame frame1 = Frame.newBuilder().command("ERROR").payload("Required 'destination' header missed").build();
            this.emitter.sendTo(socket, frame1);
        } else {
            this.emitter.sendTo(destination, frame);
        }
    }

    public void onAck(WebSocket socket, Frame frame) {
    }

    protected void unSubscribeHandle(Function<SubscriptionInfo, Boolean> function) {
        Iterator<SubscriptionInfo> iterator = this.operations.getSubscriptionInfos().iterator();
        while (iterator.hasNext()) {
            if (!function.apply(iterator.next()).booleanValue()) continue;
            iterator.remove();
        }
    }
}

