/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.broker;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.lang.Preview;
import org.noear.solon.net.annotation.ServerEndpoint;
import org.noear.solon.net.stomp.StompEmitter;
import org.noear.solon.net.stomp.broker.ToStompWebSocketListener;
import org.noear.solon.net.stomp.broker.impl.StompBrokerMedia;
import org.noear.solon.net.stomp.listener.StompListener;
import org.noear.solon.net.websocket.WebSocketListener;
import org.noear.solon.net.websocket.WebSocketListenerSupplier;

@Preview(value="3.0")
public class StompBroker
implements WebSocketListenerSupplier {
    protected final ToStompWebSocketListener webSocketListener;
    protected final StompBrokerMedia brokerMedia;

    public StompBroker() {
        ServerEndpoint serverEndpoint = this.getClass().getAnnotation(ServerEndpoint.class);
        if (serverEndpoint == null || Utils.isEmpty((String)serverEndpoint.value())) {
            throw new IllegalArgumentException("Endpoint is not empty");
        }
        this.brokerMedia = new StompBrokerMedia();
        this.webSocketListener = new ToStompWebSocketListener(serverEndpoint.value(), this.brokerMedia);
        BeanWrap bw = Solon.context().wrap(serverEndpoint.value(), (Object)this.brokerMedia.emitter);
        Solon.context().putWrap(serverEndpoint.value(), bw);
        Solon.context().putWrap(StompEmitter.class, bw);
    }

    public WebSocketListener getWebSocketListener() {
        return this.webSocketListener;
    }

    public void addServerListener(StompListener ... listeners) {
        for (StompListener listener : listeners) {
            this.brokerMedia.listeners.add(listener);
        }
    }

    public StompEmitter getServerEmitter() {
        return this.brokerMedia.emitter;
    }
}

