/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp;

import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.SimpleFrame;

public class FrameBuilder {
    private String command = "";
    private final MultiMap<String> headers = new MultiMap();
    private String payload;
    private String source;

    public FrameBuilder source(String source) {
        this.source = source;
        return this;
    }

    public FrameBuilder command(String command) {
        if (command != null) {
            this.command = command;
        }
        return this;
    }

    public FrameBuilder payload(String payload) {
        this.payload = payload;
        return this;
    }

    public FrameBuilder headers(KeyValue<String> ... headers) {
        for (KeyValue<String> kv : headers) {
            this.headers.holder(kv.getKey()).addValue(kv.getValue());
        }
        return this;
    }

    public FrameBuilder headers(Iterable<KeyValues<String>> headers) {
        for (KeyValues<String> kv : headers) {
            for (String val : kv.getValues()) {
                this.headers.holder(kv.getKey()).addValue((Object)val);
            }
        }
        return this;
    }

    public FrameBuilder header(String key, String val) {
        if (key != null && val != null) {
            this.headers.holder(key).addValue((Object)val);
        }
        return this;
    }

    public FrameBuilder contentType(String contentType) {
        if (Utils.isNotEmpty((String)contentType)) {
            return this.header("content-type", contentType);
        }
        return this;
    }

    public FrameBuilder destination(String destination) {
        if (Utils.isNotEmpty((String)destination)) {
            return this.header("destination", destination);
        }
        return this;
    }

    public Frame build() {
        return new SimpleFrame(this.source, this.command, this.payload, this.headers);
    }
}

