/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp;

import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.FrameBuilder;
import org.noear.solon.net.stomp.FrameCodec;

public class FrameCodecDefault
implements FrameCodec {
    private String commandEnd = "\n";
    private String headersEnd = "\n\n";
    private String headerDelimiter = "\n";
    private String headerKvDelimiter = ":";
    private String bodyEnd = "\u0000";
    private ReentrantLock LOCK = new ReentrantLock();
    private final StringBuilder PENDING = new StringBuilder();

    @Override
    public String encode(Frame frame) {
        StringBuilder buf = new StringBuilder();
        buf.append(frame.getCommand());
        buf.append(this.commandEnd);
        if (frame.getHeaderAll().size() > 0) {
            for (KeyValue<String> kv : frame.getHeaderAll()) {
                buf.append(kv.getKey()).append(this.headerKvDelimiter).append((String)kv.getValue());
                buf.append(this.headerDelimiter);
            }
            buf.setLength(buf.length() - 1);
        }
        buf.append(this.headersEnd);
        if (frame.getPayload() != null) {
            buf.append(frame.getPayload());
        }
        buf.append(this.bodyEnd);
        return buf.toString();
    }

    @Override
    public void decode(String input, Consumer<Frame> out) {
        if (Utils.isEmpty((String)input)) {
            return;
        }
        this.LOCK.lock();
        try {
            this.PENDING.append(input);
            this.decode(out, 0);
        }
        finally {
            this.LOCK.unlock();
        }
    }

    protected void decode(Consumer<Frame> out, int start) {
        this.cleanPendingStartData(start);
        int bEndIdx = this.PENDING.indexOf(this.bodyEnd);
        if (bEndIdx < 0) {
            return;
        }
        int cEndIdx = this.PENDING.indexOf(this.commandEnd);
        int hEndIdx = this.PENDING.indexOf(this.headersEnd);
        if (cEndIdx <= 0 || hEndIdx <= cEndIdx || bEndIdx <= hEndIdx) {
            this.decode(out, 1);
            return;
        }
        String command = this.PENDING.substring(0, cEndIdx).trim();
        if (!this.isCommand(command)) {
            this.decode(out, 1);
            return;
        }
        FrameBuilder builder = Frame.newBuilder();
        builder.command(command);
        this.decodeHeaders(builder, cEndIdx, hEndIdx);
        String payload = this.PENDING.substring(hEndIdx + this.headersEnd.length(), bEndIdx);
        builder.payload(payload);
        out.accept(builder.build());
        this.decode(out, bEndIdx + this.bodyEnd.length());
    }

    protected void cleanPendingStartData(int start) {
        if (start > 0) {
            this.PENDING.delete(0, start);
        }
        int index = 0;
        for (int i = 0; i < this.PENDING.length(); ++i) {
            char c = this.PENDING.charAt(i);
            if (!this.isCommandChar(c)) continue;
            index = i;
            break;
        }
        if (index > 0) {
            this.PENDING.delete(0, index);
        }
    }

    protected void decodeHeaders(FrameBuilder builder, int cEndIdx, int hEndIdx) {
        String[] strHeaders;
        for (String header : strHeaders = this.PENDING.substring(cEndIdx + this.commandEnd.length(), hEndIdx).split(this.headerDelimiter)) {
            int start;
            if (header == null || (start = header.indexOf(this.headerKvDelimiter)) < 1) continue;
            String name = header.substring(0, start);
            String value = header.substring(start + this.headerKvDelimiter.length(), header.length());
            builder.header(name, value);
        }
    }

    protected boolean isCommand(String command) {
        return !command.isEmpty() && command.matches("[A-Z]+");
    }

    protected boolean isCommandChar(char c) {
        return c >= 'A' && c <= 'Z';
    }
}

