/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp;

import java.util.Collection;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.net.stomp.Frame;

class SimpleFrame
implements Frame {
    protected final String command;
    protected final List<KeyValue<String>> headers;
    protected final String payload;

    public SimpleFrame(String command, String payload, List<KeyValue<String>> headers) {
        this.command = Utils.isEmpty((String)command) ? "MESSAGE" : command;
        this.payload = payload;
        this.headers = headers;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public String getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        for (KeyValue<String> h : this.headers) {
            if (!key.equals(h.getKey())) continue;
            return (String)h.getValue();
        }
        return null;
    }

    @Override
    public Collection<KeyValue<String>> getHeaderAll() {
        return this.headers;
    }

    public String toString() {
        return "Frame{command='" + this.command + '\'' + ", headers=" + this.headers + ", payload='" + this.payload + '\'' + '}';
    }
}

