/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import java.io.IOException;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.StompEmitter;
import org.noear.solon.net.stomp.handle.StompReturnHandler;
import org.noear.solon.net.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompContext
extends ContextEmpty {
    private static final Logger log = LoggerFactory.getLogger(StompContext.class);
    private WebSocket session;
    private Frame message;
    private String destination;
    private StompEmitter sender;

    public StompContext(WebSocket session, Frame message, String destination, StompEmitter sender) {
        this.session = session;
        this.message = message;
        this.destination = destination;
        this.sender = sender;
        this.attrSet("ATTR_RETURN_HANDLER", StompReturnHandler.getInstance());
    }

    public Object request() {
        return this.session;
    }

    public Frame getMessage() {
        return this.message;
    }

    public StompEmitter getSender() {
        return this.sender;
    }

    public String sessionId() {
        return this.session.id();
    }

    public String path() {
        return this.destination;
    }

    public String contentType() {
        return this.message.getHeader("content-type");
    }

    public String body(String charset) throws IOException {
        return this.message.getPayload();
    }

    public MultiMap<String> headerMap() {
        if (this.headerMap == null) {
            this.headerMap = new MultiMap();
            for (KeyValue<String> kv : this.message.getHeaderAll()) {
                this.headerMap.add(kv.getKey(), kv.getValue());
            }
        }
        return this.headerMap;
    }

    public Object pull(Class<?> clz) {
        if (Frame.class.isAssignableFrom(clz)) {
            return this.message;
        }
        if (WebSocket.class.isAssignableFrom(clz)) {
            return this.session;
        }
        return null;
    }

    public void tryHandle() {
        try {
            Handler handler = Solon.app().router().matchMain((Context)this);
            if (handler != null) {
                handler.handle((Context)this);
            }
        }
        catch (Throwable ex) {
            log.warn(ex.getMessage(), ex);
        }
    }
}

