/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.impl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompBrokerSender;
import org.noear.solon.net.stomp.impl.StompMessageOperations;
import org.noear.solon.net.websocket.WebSocket;

public final class StompMessageSenderImpl
implements StompBrokerSender {
    private StompMessageOperations operations = new StompMessageOperations();

    public StompMessageOperations getOperations() {
        return this.operations;
    }

    @Override
    public void sendTo(WebSocket session, Message message) {
        if (session.isValid()) {
            session.send(ByteBuffer.wrap(this.operations.getMsgCodec().encode(message).getBytes(StandardCharsets.UTF_8)));
        }
    }

    @Override
    public void sendTo(String destination, Message message) {
        this.operations.getDestinationInfoSet().parallelStream().filter(destinationInfo -> this.operations.getDestinationMatch().get(destinationInfo.getDestination()).matcher(destination).matches()).forEach(destinationInfo -> {
            WebSocket sendSocket = this.operations.getWebSocketMap().get(destinationInfo.getSessionId());
            if (sendSocket != null) {
                this.sendTo(sendSocket, message);
            }
        });
    }
}

