/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.net.stomp.Message;

public class MessageBuilder {
    private String command;
    private List<KeyValue<String>> headers = new ArrayList<KeyValue<String>>();
    private String payload;

    public MessageBuilder command(String command) {
        this.command = command;
        return this;
    }

    public MessageBuilder payload(String payload) {
        this.payload = payload;
        return this;
    }

    public MessageBuilder headers(KeyValue<String> ... headers) {
        for (KeyValue<String> header : headers) {
            this.headers.add(header);
        }
        return this;
    }

    public MessageBuilder header(String key, String val) {
        this.headers.add((KeyValue<String>)new KeyValue(key, (Object)val));
        return this;
    }

    public MessageBuilder contentType(String contentType) {
        if (Utils.isNotEmpty((String)contentType)) {
            return this.header("content-type", contentType);
        }
        return this;
    }

    public MessageBuilder destination(String destination) {
        if (Utils.isNotEmpty((String)destination)) {
            return this.header("destination", destination);
        }
        return this;
    }

    public Message build() {
        return new MessageImpl(this.command, this.payload, this.headers);
    }

    static class MessageImpl
    implements Message {
        private final String command;
        private final List<KeyValue<String>> headers;
        private final String payload;

        public MessageImpl(String command, String payload, List<KeyValue<String>> headers) {
            this.command = Utils.isEmpty((String)command) ? command : "MESSAGE";
            this.payload = payload;
            this.headers = headers;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public String getPayload() {
            return this.payload;
        }

        @Override
        public String getHeader(String key) {
            if (this.headers == null) {
                return null;
            }
            for (KeyValue<String> h : this.headers) {
                if (!key.equals(h.getKey())) continue;
                return (String)h.getValue();
            }
            return null;
        }

        @Override
        public Collection<KeyValue<String>> getHeaderAll() {
            return this.headers;
        }

        public String toString() {
            return "Message{command='" + this.command + '\'' + ", headers=" + this.headers + ", payload='" + this.payload + '\'' + '}';
        }
    }
}

