/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompBrokerSender;
import org.noear.solon.net.stomp.handle.StompReturnHandler;
import org.noear.solon.net.stomp.impl.DestinationInfo;
import org.noear.solon.net.websocket.WebSocket;

public class StompContext
extends ContextEmpty {
    private WebSocket session;
    private Message message;
    private DestinationInfo destinationInfo;
    private StompBrokerSender messageSender;

    public StompContext(WebSocket session, Message message, DestinationInfo destinationInfo) {
        this.session = session;
        this.message = message;
        this.destinationInfo = destinationInfo;
        this.messageSender = (StompBrokerSender)session.attr("STOMP_MESSAGE_SENDER");
        for (KeyValue<String> kv : message.getHeaderAll()) {
            this.headerMap().add(kv.getKey(), kv.getValue());
        }
        this.attrSet("ATTR_RETURN_HANDLER", StompReturnHandler.getInstance());
    }

    public WebSocket getSession() {
        return this.session;
    }

    public Message getMessage() {
        return this.message;
    }

    public StompBrokerSender getMessageSender() {
        return this.messageSender;
    }

    public String sessionId() {
        return this.session.id();
    }

    public String contentType() {
        return this.message.getHeader("content-type");
    }

    public String path() {
        return this.destinationInfo.getDestination();
    }

    public Object pull(Class<?> clz) {
        if (Message.class.isAssignableFrom(clz)) {
            return this.message;
        }
        if (WebSocket.class.isAssignableFrom(clz)) {
            return this.session;
        }
        return null;
    }

    public void tryHandle() throws Throwable {
        Handler handler = Solon.app().router().matchMain((Context)this);
        if (handler == null) {
            throw new IllegalStateException("No mapping registration");
        }
        handler.handle((Context)this);
    }
}

