/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.Solon;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.lang.Nullable;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompBrokerSender;
import org.noear.solon.net.stomp.StompListener;
import org.noear.solon.net.stomp.impl.StompListenerImpl;
import org.noear.solon.net.stomp.impl.StompMessageSenderImpl;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToStompWebSocketListener
implements WebSocketListener,
SubProtocolCapable {
    static Logger log = LoggerFactory.getLogger(ToStompWebSocketListener.class);
    private final List<StompListener> listenerList = new ArrayList<StompListener>();
    private final StompMessageSenderImpl messageSender;

    protected ToStompWebSocketListener() {
        this(null);
    }

    protected ToStompWebSocketListener(String endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint is not empty");
        }
        this.messageSender = new StompMessageSenderImpl();
        BeanWrap bw = Solon.context().wrap(endpoint, (Object)this.messageSender);
        Solon.context().putWrap(endpoint, bw);
        Solon.context().putWrap(StompBrokerSender.class, bw);
        this.addListener(new StompListenerImpl(this.messageSender));
    }

    public void addListener(StompListener ... listeners) {
        for (StompListener listener : listeners) {
            this.listenerList.add(listener);
        }
    }

    public String getSubProtocols(@Nullable Collection<String> requestProtocols) {
        return "stomp";
    }

    public void onOpen(WebSocket socket) {
        socket.attr("STOMP_MESSAGE_SENDER", (Object)this.messageSender);
        for (StompListener listener : this.listenerList) {
            listener.onOpen(socket);
        }
    }

    public void onMessage(WebSocket socket, String text) throws IOException {
        AtomicBoolean atomicBoolean = new AtomicBoolean(Boolean.TRUE);
        this.messageSender.getOperations().getMsgCodec().decode(text, msg -> {
            String command;
            atomicBoolean.set(Boolean.FALSE);
            switch (command = msg.getCommand() == null ? "" : msg.getCommand()) {
                case "CONNECT": {
                    for (StompListener listener : this.listenerList) {
                        listener.onConnect(socket, (Message)msg);
                    }
                    break;
                }
                case "DISCONNECT": {
                    for (StompListener listener : this.listenerList) {
                        listener.onDisconnect(socket, (Message)msg);
                    }
                    break;
                }
                case "SUBSCRIBE": {
                    for (StompListener listener : this.listenerList) {
                        listener.onSubscribe(socket, (Message)msg);
                    }
                    break;
                }
                case "UNSUBSCRIBE": {
                    for (StompListener listener : this.listenerList) {
                        listener.onUnsubscribe(socket, (Message)msg);
                    }
                    break;
                }
                case "SEND": {
                    for (StompListener listener : this.listenerList) {
                        listener.onSend(socket, (Message)msg);
                    }
                    break;
                }
                case "ACK": 
                case "NACK": {
                    for (StompListener listener : this.listenerList) {
                        listener.onAck(socket, (Message)msg);
                    }
                    break;
                }
                default: {
                    log.warn("session unknown, {}\r\n{}", (Object)socket.id(), (Object)text);
                    this.doSend(socket, Message.newBuilder().command("UNKNOWN").payload(text).build());
                }
            }
        });
        if (atomicBoolean.get()) {
            if (log.isDebugEnabled()) {
                log.debug("session ping, {}", (Object)socket.id());
            }
            this.doSend(socket, Message.newBuilder().command("MESSAGE").payload(text).build());
        }
    }

    protected void doSend(WebSocket socket, Message message) {
        this.messageSender.sendTo(socket, message);
    }

    public void onMessage(WebSocket socket, ByteBuffer binary) throws IOException {
        String txt = Charset.forName("UTF-8").decode(binary).toString();
        this.onMessage(socket, txt);
    }

    public void onClose(WebSocket socket) {
        for (StompListener listener : this.listenerList) {
            listener.onClose(socket);
        }
    }

    public void onError(WebSocket socket, Throwable error) {
        log.error("", error);
    }
}

