/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.noear.solon.net.stomp.Header;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompListener;
import org.noear.solon.net.stomp.impl.DestinationInfo;
import org.noear.solon.net.stomp.impl.MessageImpl;
import org.noear.solon.net.stomp.impl.StompMessageOperations;
import org.noear.solon.net.stomp.impl.StompMessageSendingTemplate;
import org.noear.solon.net.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StompListenerImpl
implements StompListener {
    static Logger log = LoggerFactory.getLogger(StompListenerImpl.class);
    private StompMessageOperations stompMessageOperations;
    private StompMessageSendingTemplate stompMessageSendingTemplate;

    public StompListenerImpl(StompMessageOperations stompMessageOperations, StompMessageSendingTemplate stompMessageSendingTemplate) {
        this.stompMessageOperations = stompMessageOperations;
        this.stompMessageSendingTemplate = stompMessageSendingTemplate;
    }

    @Override
    public void onOpen(WebSocket socket) {
        this.stompMessageOperations.getWebSocketMap().put(socket.id(), socket);
    }

    @Override
    public void onClose(WebSocket socket) {
        this.stompMessageOperations.getWebSocketMap().remove(socket);
        this.onUnsubscribe(socket, null);
    }

    @Override
    public void onConnect(WebSocket socket, Message message) {
        String heartBeat = message.getHeader("heart-beat");
        this.stompMessageSendingTemplate.send(socket, new MessageImpl("CONNECTED", Arrays.asList(new Header("heart-beat", heartBeat == null ? "0,0" : heartBeat), new Header("server", "stomp"), new Header("version", "1.2"))));
    }

    @Override
    public void onDisconnect(WebSocket socket, Message message) {
        String receiptId = message.getHeader("receipt");
        this.stompMessageSendingTemplate.send(socket, new MessageImpl("RECEIPT", Arrays.asList(new Header("receipt-id", receiptId))));
    }

    @Override
    public void onSubscribe(WebSocket socket, Message message) {
        String receiptId;
        String subscriptionId = message.getHeader("id");
        String destination = message.getHeader("destination");
        if (destination == null || destination.length() == 0 || subscriptionId == null || subscriptionId.length() == 0) {
            this.stompMessageSendingTemplate.send(socket, new MessageImpl("ERROR", "Required 'destination' or 'id' header missed"));
            return;
        }
        DestinationInfo destinationInfo = new DestinationInfo();
        destinationInfo.setSessionId(socket.id());
        destinationInfo.setDestination(destination);
        destinationInfo.setSubscription(subscriptionId);
        this.stompMessageOperations.getDestinationInfoSet().add(destinationInfo);
        if (!this.stompMessageOperations.getDestinationMatch().containsKey(destination)) {
            String destinationRegexp = "^" + destination.replaceAll("\\*\\*", ".+").replaceAll("\\*", ".+") + "$";
            this.stompMessageOperations.getDestinationMatch().put(destination, Pattern.compile(destinationRegexp));
        }
        if ((receiptId = message.getHeader("receipt")) != null) {
            this.stompMessageSendingTemplate.send(socket, new MessageImpl("RECEIPT", Arrays.asList(new Header("receipt-id", receiptId))));
        }
    }

    @Override
    public void onUnsubscribe(WebSocket socket, Message message) {
        String sessionId = socket.id();
        if (message == null) {
            this.unSubscribeHandle(destinationInfo -> sessionId.equals(destinationInfo.getSessionId()));
        } else {
            String subscription = message.getHeader("id");
            String destination = message.getHeader("destination");
            this.unSubscribeHandle(destinationInfo -> sessionId.equals(destinationInfo.getSessionId()) && (destinationInfo.getDestination().equals(destination) || destinationInfo.getSubscription().equals(subscription)));
        }
    }

    @Override
    public void onSend(WebSocket socket, Message message) {
        String destination = message.getHeader("destination");
        if (destination == null || destination.length() == 0) {
            this.stompMessageSendingTemplate.send(socket, new MessageImpl("ERROR", "Required 'destination' header missed"));
            return;
        }
        this.stompMessageSendingTemplate.send(destination, message.getPayload(), message.getHeader("content-type"));
    }

    @Override
    public void onAck(WebSocket socket, Message message) {
    }

    protected void unSubscribeHandle(Function<DestinationInfo, Boolean> function) {
        Iterator<DestinationInfo> iterator = this.stompMessageOperations.getDestinationInfoSet().iterator();
        while (iterator.hasNext()) {
            if (!function.apply(iterator.next()).booleanValue()) continue;
            iterator.remove();
        }
    }
}

