/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.textstream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.noear.solon.net.http.textstream.ServerSentEvent;
import org.noear.solon.rx.SimpleSubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class TextStreamUtil {
    public static void parseTextStream(InputStream inputStream, Subscriber<? super String> subscriber) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), 1024);){
            subscriber.onSubscribe((Subscription)new SimpleSubscription().onRequest((subscription, l) -> {
                try {
                    while (l > 0L && !subscription.isCancelled()) {
                        Long l2 = l;
                        Long l3 = l = Long.valueOf(l - 1L);
                        String textLine = reader.readLine();
                        if (textLine == null) {
                            subscriber.onComplete();
                            break;
                        }
                        subscriber.onNext((Object)textLine);
                    }
                }
                catch (Throwable err) {
                    subscriber.onError(err);
                }
            }));
        }
        catch (Throwable err) {
            subscriber.onError(err);
        }
    }

    public static void parseEventStream(InputStream inputStream, Subscriber<? super ServerSentEvent> subscriber) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), 1024);){
            subscriber.onSubscribe((Subscription)new SimpleSubscription().onRequest((subscription, l) -> {
                try {
                    HashMap<String, String> meta = new HashMap<String, String>();
                    StringBuilder data = new StringBuilder();
                    while (l > 0L && !subscription.isCancelled()) {
                        Long l2 = l;
                        Long l3 = l = Long.valueOf(l - 1L);
                        String textLine = reader.readLine();
                        if (textLine == null) {
                            subscriber.onComplete();
                            break;
                        }
                        if (textLine.isEmpty()) {
                            if (data.length() <= 0) continue;
                            subscriber.onNext((Object)new ServerSentEvent(meta, data.toString()));
                            meta = new HashMap();
                            data.setLength(0);
                            continue;
                        }
                        if (textLine.startsWith("data:")) {
                            String content = textLine.substring("data:".length());
                            if (data.length() > 0) {
                                data.append("\n");
                            }
                            data.append(content.trim());
                            continue;
                        }
                        int flagIdx = textLine.indexOf(58);
                        if (flagIdx <= 0) continue;
                        meta.put(textLine.substring(0, flagIdx).trim(), textLine.substring(flagIdx + 1).trim());
                    }
                }
                catch (Throwable err) {
                    subscriber.onError(err);
                }
            }));
        }
    }
}

