/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.mvc;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Addition;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.ActionLoader;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.mvc.ActionDefault;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ProxyBinder;

public class ActionLoaderDefault
extends HandlerAide
implements ActionLoader {
    protected final BeanWrap bw;
    protected final Render bRender;
    protected final Mapping bMapping;
    protected final String bPath;
    protected final boolean bRemoting;
    protected final boolean allowMapping;

    public ActionLoaderDefault(BeanWrap wrap) {
        this(wrap, null, wrap.remoting(), null, true);
    }

    public ActionLoaderDefault(BeanWrap wrap, String mapping, boolean remoting, Render render, boolean allowMapping) {
        if (render == null && wrap.raw() instanceof Render) {
            render = (Render)wrap.raw();
        }
        if (mapping == null) {
            this.bMapping = wrap.clz().getAnnotation(Mapping.class);
            if (this.bMapping != null) {
                mapping = Utils.annoAlias((String)this.bMapping.value(), (String)this.bMapping.path());
            }
        } else {
            this.bMapping = null;
        }
        this.bw = wrap;
        this.bRender = render;
        this.allowMapping = allowMapping;
        this.bPath = Utils.annoAlias((String)mapping, (String)"");
        this.bRemoting = remoting;
    }

    public String mapping() {
        return this.bPath;
    }

    public void load(HandlerSlots slots) {
        this.load(this.bRemoting, slots);
    }

    protected void load(boolean all, HandlerSlots slots) {
        if (Handler.class.isAssignableFrom(this.bw.clz())) {
            this.loadHandlerDo(slots);
        } else {
            this.loadActions(slots, all || this.bRemoting);
        }
    }

    protected void loadHandlerDo(HandlerSlots slots) {
        if (this.bMapping == null) {
            throw new IllegalStateException(this.bw.clz().getName() + " No @Mapping!");
        }
        Handler handler = (Handler)this.bw.raw();
        HashSet<MethodType> v0 = Solon.app().factoryManager().mvcFactory().findMethodTypes(new HashSet(), t -> this.bw.annotationGet(t) != null);
        if (v0.size() == 0) {
            v0 = new HashSet<MethodType>(Arrays.asList(this.bMapping.method()));
        }
        slots.add(this.bMapping, (Set)v0, handler);
    }

    protected void loadActions(HandlerSlots slots, boolean all) {
        HashSet<MethodType> b_limitMethodSet = new HashSet<MethodType>();
        HashSet<MethodType> b_addinMethodSet = new HashSet<MethodType>();
        Solon.app().factoryManager().mvcFactory().findMethodTypes(b_limitMethodSet, t -> this.bw.clz().getAnnotation(t) != null);
        this.loadControllerAide(b_addinMethodSet);
        if (b_limitMethodSet.size() == 0 && this.bMapping != null) {
            for (MethodType b_mt : this.bMapping.method()) {
                if (b_mt == MethodType.ALL) continue;
                b_limitMethodSet.add(b_mt);
            }
        }
        boolean enableProxy = false;
        for (Method method : ClassUtil.findPublicMethods((Class)this.bw.clz())) {
            this.loadActionItem(slots, all, method, b_limitMethodSet, b_addinMethodSet);
            if (!Modifier.isPublic(method.getModifiers())) continue;
            enableProxy = enableProxy || this.bw.context().beanInterceptorHas((AnnotatedElement)method);
        }
        boolean bl = enableProxy = enableProxy || this.bw.context().beanInterceptorHas((AnnotatedElement)this.bw.rawClz());
        if (enableProxy) {
            ProxyBinder.global().binding(this.bw);
        }
    }

    protected void loadActionItem(HandlerSlots slots, boolean all, Method method, Set<MethodType> b_limitMethodSet, Set<MethodType> b_addinMethodSet) {
        String m_path;
        Mapping m_map = method.getAnnotation(Mapping.class);
        if (m_map == null) {
            if (!Modifier.isPublic(method.getModifiers())) {
                return;
            }
        } else if (!Modifier.isPublic(method.getModifiers())) {
            LogUtil.global().warn("This @Mapping method is not public: " + method.getDeclaringClass().getName() + ":" + method.getName());
        }
        HashSet<MethodType> m_limitMethodSet = new HashSet<MethodType>(b_limitMethodSet);
        HashSet<MethodType> m_addinMethodSet = new HashSet<MethodType>(b_addinMethodSet);
        Solon.app().factoryManager().mvcFactory().findMethodTypes(m_limitMethodSet, t -> method.getAnnotation(t) != null);
        if (m_map != null) {
            m_path = Utils.annoAlias((String)m_map.value(), (String)m_map.path());
            if (m_limitMethodSet.size() == 0) {
                m_limitMethodSet.addAll(Arrays.asList(m_map.method()));
            }
        } else {
            m_path = method.getName();
            if (m_limitMethodSet.size() == 0) {
                if (this.bMapping == null) {
                    m_limitMethodSet.add(MethodType.HTTP);
                } else {
                    m_limitMethodSet.addAll(Arrays.asList(this.bMapping.method()));
                }
            }
        }
        if (m_map != null || all) {
            String newPath = this.postActionPath(this.bw, this.bPath, method, m_path);
            ActionDefault action = this.createAction(this.bw, method, m_map, newPath, this.bRemoting);
            this.loadActionAide(method, action, m_addinMethodSet);
            if (m_limitMethodSet.size() > 0 && !m_limitMethodSet.contains(MethodType.HTTP) && !m_limitMethodSet.contains(MethodType.ALL)) {
                m_limitMethodSet.addAll(m_addinMethodSet);
            }
            for (MethodType m1 : m_limitMethodSet) {
                slots.add(newPath, m1, (Handler)action);
            }
        }
    }

    protected void loadControllerAide(Set<MethodType> addinMethodSet) {
        for (Annotation anno : this.bw.clz().getAnnotations()) {
            if (this.loadControllerAideAdd(anno, addinMethodSet)) continue;
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                this.loadControllerAideAdd(anno2, addinMethodSet);
            }
        }
    }

    protected boolean loadControllerAideAdd(Annotation anno, Set<MethodType> addinMethodSet) {
        if (anno instanceof Addition) {
            Addition additionAnno = (Addition)anno;
            for (Class clz : additionAnno.value()) {
                MethodType methodType;
                if (Filter.class.isAssignableFrom(clz)) {
                    this.filter(additionAnno.index(), (Filter)this.bw.context().getBeanOrNew(clz));
                    continue;
                }
                if (!Annotation.class.isAssignableFrom(clz) || (methodType = MethodTypeUtil.valueOf((String)clz.getSimpleName().toUpperCase())) == MethodType.UNKNOWN) continue;
                addinMethodSet.add(methodType);
            }
            return true;
        }
        return false;
    }

    protected void loadActionAide(Method method, ActionDefault action, Set<MethodType> addinMethodSet) {
        for (Annotation anno : method.getAnnotations()) {
            if (this.loadActionAideAdd(anno, action, addinMethodSet)) continue;
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                this.loadActionAideAdd(anno2, action, addinMethodSet);
            }
        }
    }

    protected boolean loadActionAideAdd(Annotation anno, ActionDefault action, Set<MethodType> addinMethodSet) {
        if (anno instanceof Addition) {
            Addition additionAnno = (Addition)anno;
            for (Class clz : additionAnno.value()) {
                MethodType methodType;
                if (Filter.class.isAssignableFrom(clz)) {
                    action.filter(additionAnno.index(), (Filter)this.bw.context().getBeanOrNew(clz));
                    continue;
                }
                if (!Annotation.class.isAssignableFrom(clz) || (methodType = MethodTypeUtil.valueOf((String)clz.getSimpleName().toUpperCase())) == MethodType.UNKNOWN) continue;
                addinMethodSet.add(methodType);
            }
            return true;
        }
        return false;
    }

    protected String postActionPath(BeanWrap bw, String bPath, Method method, String mPath) {
        return Solon.app().factoryManager().mvcFactory().postActionPath(bw, bPath, method, mPath);
    }

    protected ActionDefault createAction(BeanWrap bw, Method method, Mapping mp, String path, boolean remoting) {
        if (this.allowMapping) {
            return new ActionDefault(bw, this, method, mp, path, remoting, this.bRender);
        }
        return new ActionDefault(bw, this, method, null, path, remoting, this.bRender);
    }

    protected <T> void addDo(T[] ary, ConsumerEx<T> fun) {
        if (ary != null) {
            for (T t : ary) {
                try {
                    fun.accept(t);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

