/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.noear.solon.maven.plugin.tools.StringUtils;

public class SolonMavenUtil {
    private static final String DOT_CLASS = ".class";
    private static final FileFilter CLASS_FILE_FILTER = file -> file.isFile() && file.getName().endsWith(DOT_CLASS);
    private static final FileFilter PACKAGE_DIRECTORY_FILTER = file -> file.isDirectory() && !file.getName().startsWith(".");

    public static String getStartClass(File file, String mainClass, Log logger) throws IOException {
        Serializable itemFile;
        if (StringUtils.isNotEmpty(mainClass)) {
            return mainClass;
        }
        ArrayList<String> mains = new ArrayList<String>();
        ClassPool classPool = ClassPool.getDefault();
        if (file.isDirectory()) {
            ArrayDeque<File> stack = new ArrayDeque<File>();
            stack.push(file);
            while (!stack.isEmpty()) {
                itemFile = (File)stack.pop();
                if (((File)itemFile).isFile()) {
                    try {
                        InputStream inputStream = Files.newInputStream(((File)itemFile).toPath(), new OpenOption[0]);
                        CtClass ctClass = classPool.makeClass(inputStream);
                        inputStream.close();
                        String solonMain = SolonMavenUtil.getSolonMainClass(ctClass, mains);
                        if (solonMain != null) {
                            logger.info((CharSequence)("Checked startup class: " + ctClass.getName()));
                            return solonMain;
                        }
                    }
                    catch (IOException | NotFoundException inputStream) {
                        // empty catch block
                    }
                }
                if (!((File)itemFile).isDirectory()) continue;
                SolonMavenUtil.pushAllSorted(stack, ((File)itemFile).listFiles(PACKAGE_DIRECTORY_FILTER));
                SolonMavenUtil.pushAllSorted(stack, ((File)itemFile).listFiles(CLASS_FILE_FILTER));
            }
        } else {
            JarFile jar = new JarFile(file);
            itemFile = null;
            try {
                Enumeration<JarEntry> enumFiles = jar.entries();
                while (enumFiles.hasMoreElements()) {
                    JarEntry entry = enumFiles.nextElement();
                    String classFullName = entry.getName();
                    if (!classFullName.endsWith(DOT_CLASS)) continue;
                    try {
                        InputStream inputStream = jar.getInputStream(entry);
                        CtClass ctClass = classPool.makeClass(inputStream);
                        inputStream.close();
                        String solonMain = SolonMavenUtil.getSolonMainClass(ctClass, mains);
                        if (solonMain != null) {
                            logger.info((CharSequence)("Checked startup class: " + ctClass.getName()));
                            String string = solonMain;
                            return string;
                        }
                    }
                    finally {
                    }
                }
            }
            catch (Throwable enumFiles) {
                itemFile = enumFiles;
                throw enumFiles;
            }
            finally {
                if (jar != null) {
                    if (itemFile != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)itemFile).addSuppressed(throwable);
                        }
                    } else {
                        jar.close();
                    }
                }
            }
        }
        if (mains.size() > 0) {
            String tempMain;
            if (mains.size() == 1) {
                logger.info((CharSequence)("Checked startup class: " + (String)mains.get(0)));
                return (String)mains.get(0);
            }
            logger.info((CharSequence)"Checked startup class: ");
            for (int i = 0; i < mains.size(); ++i) {
                logger.info((CharSequence)(i + "\u3001" + (String)mains.get(i)));
            }
            logger.info((CharSequence)"Please select a main function as the launch function (for example, enter 0 carriage return) :");
            Scanner scanner = new Scanner(System.in);
            while (true) {
                if (!scanner.hasNextLine()) {
                    continue;
                }
                try {
                    String s = scanner.nextLine();
                    int i = Integer.parseInt(s);
                    tempMain = (String)mains.get(i);
                }
                catch (Exception e) {
                    logger.error((CharSequence)"Failed to select. Please select again");
                    continue;
                }
                break;
            }
            scanner.close();
            return tempMain;
        }
        throw new IllegalStateException("Unable to find startup class, please configure your startup class");
    }

    public static String getJavaExecutable(ToolchainManager toolchainManager, MavenSession mavenSession) {
        Toolchain toolchain = toolchainManager.getToolchainFromBuildContext("jdk", mavenSession);
        String javaExecutable = toolchain != null ? toolchain.findTool("java") : null;
        return javaExecutable != null ? javaExecutable : SolonMavenUtil.findJavaExecutable();
    }

    private static String findJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        if (StringUtils.isEmpty(javaHome)) {
            throw new IllegalStateException("Unable to find java executable due to missing 'java.home'");
        }
        File bin = new File(new File(javaHome), "bin");
        File command = new File(bin, "java.exe");
        File file = command = command.exists() ? command : new File(bin, "java");
        if (!command.exists()) {
            throw new IllegalStateException("Unable to find java in " + javaHome);
        }
        try {
            return command.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getSolonMainClass(CtClass ctClass, List<String> mains) throws NotFoundException {
        CtMethod[] methods;
        for (CtMethod method : methods = ctClass.getDeclaredMethods()) {
            if (!SolonMavenUtil.isMainMethod(method)) continue;
            mains.add(ctClass.getName());
            if (!ctClass.hasAnnotation("org.noear.solon.annotation.SolonMain")) continue;
            return ctClass.getName();
        }
        return null;
    }

    private static void pushAllSorted(Deque<File> stack, File[] files) {
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file : files) {
            stack.push(file);
        }
    }

    private static boolean isMainMethod(CtMethod method) throws NotFoundException {
        return method.getName().equals("main") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].getName().equals("java.lang.String[]") && Modifier.isStatic(method.getModifiers()) && method.getReturnType().getName().equals("void");
    }
}

