/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.noear.solon.maven.plugin.CommandLineBuilder;
import org.noear.solon.maven.plugin.JavaCompilerPluginConfiguration;
import org.noear.solon.maven.plugin.JavaProcessExecutor;
import org.noear.solon.maven.plugin.RunArguments;
import org.noear.solon.maven.plugin.tools.SolonMavenUtil;
import org.noear.solon.maven.plugin.tools.StringUtils;

@Mojo(name="process-aot", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ProcessAotMojo
extends AbstractMojo {
    private static final String AOT_PROCESSOR_CLASS_NAME = "org.noear.solon.aot.SolonAotProcessor";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/solon-aot/main/sources", required=true)
    private File generatedSources;
    @Parameter(property="solon.aot.main-class")
    private String mainClass;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter(property="solon.aot.jvmArguments")
    private String jvmArguments;
    @Parameter(property="solon.aot.compilerArguments")
    private String compilerArguments;
    @Parameter
    private String[] arguments;
    @Parameter
    private String[] envs;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Aot process start ...");
        try {
            this.executeAot();
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    protected void executeAot() throws Exception {
        URL[] classPath = this.getClassPath();
        String applicationClass = SolonMavenUtil.getStartClass(this.classesDirectory, this.mainClass, this.getLog());
        List<String> command = CommandLineBuilder.forMainClass(AOT_PROCESSOR_CLASS_NAME).withSystemProperties(this.systemPropertyVariables).withJvmArguments(new RunArguments(this.jvmArguments).asArray()).withClasspath(classPath).withArguments(this.getAotArguments(applicationClass)).build();
        this.getLog().info((CharSequence)("Generating AOT assets using command: " + command));
        JavaProcessExecutor processExecutor = new JavaProcessExecutor(this.session, this.toolchainManager);
        processExecutor.run(this.project.getBasedir(), command, Collections.emptyMap());
        this.compileSourceFiles(classPath);
        this.getLog().info((CharSequence)"Aot process succeed ...");
    }

    private void compileSourceFiles(URL[] classPath) throws Exception {
        List sourceFiles;
        if (!this.generatedSources.exists()) {
            return;
        }
        try (Stream<Path> pathStream = Files.walk(this.generatedSources.toPath(), new FileVisitOption[0]);){
            sourceFiles = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        if (sourceFiles.isEmpty()) {
            return;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);){
            JavaCompilerPluginConfiguration compilerConfiguration = new JavaCompilerPluginConfiguration(this.project);
            ArrayList<String> options = new ArrayList<String>();
            options.add("-cp");
            options.add(CommandLineBuilder.ClasspathBuilder.build(Arrays.asList(classPath)));
            options.add("-d");
            options.add(this.classesDirectory.toPath().toAbsolutePath().toString());
            String releaseVersion = compilerConfiguration.getReleaseVersion();
            if (releaseVersion != null) {
                options.add("--release");
                options.add(releaseVersion);
            } else {
                options.add("--source");
                options.add(compilerConfiguration.getSourceMajorVersion());
                options.add("--target");
                options.add(compilerConfiguration.getTargetMajorVersion());
            }
            options.addAll(new RunArguments(this.compilerArguments).getArgs());
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(this.asFiles(sourceFiles));
            Errors errors = new Errors();
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, errors, options, null, compilationUnits);
            boolean result = task.call();
            if (!result || errors.hasReportedErrors()) {
                throw new IllegalStateException("Unable to compile generated source" + errors);
            }
        }
    }

    private String[] getAotArguments(String applicationClass) {
        ArrayList<String> aotArguments = new ArrayList<String>();
        aotArguments.add(applicationClass);
        aotArguments.add(this.classesDirectory.getAbsolutePath());
        aotArguments.add(this.generatedSources.getAbsolutePath());
        aotArguments.add(this.project.getGroupId());
        aotArguments.add(this.project.getArtifactId());
        if (this.envs != null && this.envs.length != 0) {
            aotArguments.add("--solon.env=" + String.join((CharSequence)",", this.envs));
        }
        if (this.arguments != null) {
            Arrays.stream(this.arguments).filter(Objects::nonNull).forEach(aotArguments::add);
        }
        return aotArguments.toArray(new String[0]);
    }

    private URL[] getClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this.toURL(this.classesDirectory));
        Set artifacts = this.project.getArtifacts();
        List artifactUrlList = artifacts.stream().filter(artifact -> !StringUtils.equals(artifact.getScope(), "test")).map(artifact -> this.toURL(artifact.getFile())).collect(Collectors.toList());
        urls.addAll(artifactUrlList);
        return urls.toArray(new URL[0]);
    }

    protected URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Invalid URL for " + file, ex);
        }
    }

    private Iterable<File> asFiles(final Iterable<? extends Path> paths) {
        return () -> new Iterator(){
            final Iterator iter;
            {
                this.iter = paths.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public File next() {
                Path p = (Path)this.iter.next();
                try {
                    return p.toFile();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException(p.toString(), e);
                }
            }
        };
    }

    protected static class Errors
    implements DiagnosticListener<JavaFileObject> {
        private final StringBuilder message = new StringBuilder();

        protected Errors() {
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                this.message.append("\n");
                this.message.append(diagnostic.getMessage(Locale.getDefault()));
                if (diagnostic.getSource() != null) {
                    this.message.append(" ");
                    this.message.append(diagnostic.getSource().getName());
                    this.message.append(" ");
                    this.message.append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber());
                }
            }
        }

        boolean hasReportedErrors() {
            return this.message.length() > 0;
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

