/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.noear.solon.maven.plugin.ClassesMove;
import org.noear.solon.maven.plugin.CopyLoader;
import org.noear.solon.maven.plugin.PluginType;
import org.noear.solon.maven.plugin.Repackager;
import org.noear.solon.maven.plugin.tools.tool.ArtifactsLibraries;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractMojo {
    @Parameter(required=false)
    private String mainClass;
    @Parameter(readonly=false)
    private String jvmArguments;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.packaging}", required=true)
    private String packaging;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true")
    public boolean includeSystemScope;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    public static PluginType PLUGIN_TYPE;
    private final Log logger = this.getLog();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logger.info((CharSequence)("\u6253\u5305\u7c7b\u578b\uff1a" + this.packaging));
        if (this.packaging != null) {
            if ("jar".equalsIgnoreCase(this.packaging)) {
                PLUGIN_TYPE = PluginType.JAR;
                ClassesMove.change(this.project.getArtifact().getFile());
                this.repackage();
                try {
                    CopyLoader.start(this.getTargetFile());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("write loader exception", e);
                }
            } else if ("war".equalsIgnoreCase(this.packaging)) {
                PLUGIN_TYPE = PluginType.WAR;
            }
        } else {
            throw new MojoExecutionException("\u6253\u5305\u65b9\u5f0f\u4e0d\u662fJAR\u6216\u8005WAR\u7c7b\u578b");
        }
    }

    private void repackage() throws MojoExecutionException, MojoFailureException {
        try {
            File sourceFile = this.project.getArtifact().getFile();
            Repackager repackager = new Repackager(sourceFile, this.logger, this.mainClass);
            File target = this.getTargetFile();
            Set artifacts = this.project.getArtifacts();
            HashSet<Artifact> packartifacts = new HashSet();
            if (!this.includeSystemScope) {
                for (Artifact a : artifacts) {
                    if (a.getScope().equals("system")) continue;
                    packartifacts.add(a);
                }
            } else {
                packartifacts = artifacts;
            }
            ArtifactsLibraries libraries = new ArtifactsLibraries(packartifacts, Collections.emptyList(), this.getLog());
            repackager.repackage(target, libraries);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private File getTargetFile() {
        String classifier;
        String string = classifier = this.classifier != null ? this.classifier.trim() : "";
        if (classifier.length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        String name = this.finalName + classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension();
        return new File(this.outputDirectory, name);
    }
}

