/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javassist.ClassPool;
import javassist.CtMethod;
import org.apache.maven.plugin.logging.Log;
import org.noear.solon.maven.plugin.JarWriter;
import org.noear.solon.maven.plugin.tools.tool.DefaultLayoutFactory;
import org.noear.solon.maven.plugin.tools.tool.Layout;
import org.noear.solon.maven.plugin.tools.tool.LayoutFactory;
import org.noear.solon.maven.plugin.tools.tool.Libraries;
import org.noear.solon.maven.plugin.tools.tool.Library;
import org.noear.solon.maven.plugin.tools.tool.RepackagingLayout;

public class Repackager {
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private final File source;
    private final String mainClass;
    private Layout layout;
    private final Log logger;

    public Repackager(File source, Log logger, String mainClass) throws Exception {
        this.logger = logger;
        if (source == null) {
            throw new IllegalArgumentException("Source file must be provided");
        }
        if (!source.exists() || !source.isFile()) {
            throw new IllegalArgumentException("Source must refer to an existing file, got " + source.getAbsolutePath());
        }
        this.source = source.getAbsoluteFile();
        this.mainClass = mainClass == null || mainClass.trim().length() == 0 ? this.getStartClass() : mainClass;
        logger.info((CharSequence)("JAR\u7684\u542f\u52a8\u7c7b\u4e3a\uff1a" + this.mainClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getStartClass() throws IOException {
        f = this.getFile();
        jar = new JarFile(f);
        try {
            mains = new ArrayList<String>();
            enumFiles = jar.entries();
            classPool = ClassPool.getDefault();
            block10: while (enumFiles.hasMoreElements()) {
                entry = enumFiles.nextElement();
                classFullName = entry.getName();
                if (!classFullName.endsWith(".class")) continue;
                inputStream = jar.getInputStream((ZipEntry)entry);
                ctClass = classPool.makeClass(inputStream);
                inputStream.close();
                for (CtMethod method : methods = ctClass.getDeclaredMethods()) {
                    if (!method.getName().equals("main") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals("java.lang.String[]") || !Modifier.isStatic(method.getModifiers()) || !method.getReturnType().getName().equals("void")) ** break block17
                    mains.add(ctClass.getName());
                    if (!ctClass.hasAnnotation("org.noear.solon.annotation.SolonMain")) ** break block17
                    this.logger.info((CharSequence)("\u68c0\u67e5\u5230\u7684\u542f\u52a8\u7c7b\uff1a" + ctClass.getName()));
                    var15_20 = ctClass.getName();
                    return var15_20;
                }
                continue;
                {
                    try {
                        continue;
                    }
                    catch (Throwable inputStream) {
                        continue block10;
                        break;
                    }
                }
            }
            if (mains.size() > 0) {
                if (mains.size() == 1) {
                    this.logger.info((CharSequence)("\u68c0\u67e5\u5230\u7684\u542f\u52a8\u7c7b\uff1a" + (String)mains.get(0)));
                    entry = (String)mains.get(0);
                    return entry;
                }
                this.logger.info((CharSequence)"\u68c0\u67e5\u5230\u7684\u542f\u52a8\u7c7b\uff1a");
                for (i = 0; i < mains.size(); ++i) {
                    this.logger.info((CharSequence)(i + "\u3001" + (String)mains.get(i)));
                }
                this.logger.info((CharSequence)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u4e3b\u51fd\u6570\u4f5c\u4e3a\u542f\u52a8\u51fd\u6570(\u5982\uff1a\u8f93\u51650\u56de\u8f66)\uff1a");
                scanner = new Scanner(System.in);
                while (true) {
                    if (!scanner.hasNextLine()) {
                        continue;
                    }
                    try {
                        s = scanner.nextLine();
                        i = Integer.parseInt(s);
                        tempMain = (String)mains.get(i);
                    }
                    catch (Exception e) {
                        this.logger.error((CharSequence)"\u9009\u62e9\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                        continue;
                    }
                    break;
                }
                scanner.close();
                var8_10 = tempMain;
                return var8_10;
            }
        }
        finally {
            jar.close();
        }
        throw new IllegalStateException("\u627e\u4e0d\u5230\u542f\u52a8\u7c7b,\u8bf7\u914d\u7f6e\u4f60\u7684\u542f\u52a8\u7c7b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repackage(File destination, Libraries libraries) throws IOException {
        if (destination == null || destination.isDirectory()) {
            throw new IllegalArgumentException("Invalid destination");
        }
        if (libraries == null) {
            throw new IllegalArgumentException("Libraries must not be null");
        }
        if (this.layout == null) {
            this.layout = this.getLayoutFactory().getLayout(this.source);
        }
        if (this.alreadyRepackaged()) {
            return;
        }
        destination = destination.getAbsoluteFile();
        File workingSource = this.source;
        if (this.source.equals(destination)) {
            workingSource = this.getBackupFile();
            workingSource.delete();
            this.renameFile(this.source, workingSource);
        }
        destination.delete();
        try (JarFile jarFileSource = new JarFile(workingSource);){
            this.repackage(jarFileSource, destination, libraries);
        }
    }

    private LayoutFactory getLayoutFactory() {
        return new DefaultLayoutFactory();
    }

    public final File getBackupFile() {
        return new File(this.source.getParentFile(), this.source.getName() + ".original");
    }

    public final File getFile() {
        return new File(this.source.getParentFile(), this.source.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyRepackaged() throws IOException {
        try (JarFile jarFile = new JarFile(this.source);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest != null && manifest.getMainAttributes().getValue("Solon-Jar-Plugin") != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repackage(JarFile sourceJar, File destination, Libraries libraries) throws IOException {
        JarWriter writer = new JarWriter(destination);
        try {
            ArrayList<Library> unpackLibraries = new ArrayList<Library>();
            ArrayList<Library> standardLibraries = new ArrayList<Library>();
            libraries.doWithLibraries(library -> {
                File file = library.getFile();
                if (this.isZip(file)) {
                    if (library.isUnpackRequired()) {
                        unpackLibraries.add(library);
                    } else {
                        standardLibraries.add(library);
                    }
                }
            });
            this.repackage(sourceJar, writer, unpackLibraries, standardLibraries);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void repackage(JarFile sourceJar, JarWriter writer, List<Library> unpackLibraries, List<Library> standardLibraries) throws IOException {
        writer.writeManifest(this.buildManifest(sourceJar));
        HashSet<String> seen = new HashSet<String>();
        this.writeNestedLibraries(unpackLibraries, seen, writer);
        if (this.layout instanceof RepackagingLayout) {
            writer.writeEntries(sourceJar, new RenamingEntryTransformer(((RepackagingLayout)this.layout).getRepackagedClassesLocation()));
        } else {
            writer.writeEntries(sourceJar);
        }
        this.writeNestedLibraries(standardLibraries, seen, writer);
    }

    private void writeNestedLibraries(List<Library> libraries, Set<String> alreadySeen, JarWriter writer) throws IOException {
        for (Library library : libraries) {
            String destination = this.layout.getLibraryDestination(library.getName(), library.getScope());
            if (destination == null) continue;
            if (!alreadySeen.add(destination + library.getName())) {
                throw new IllegalStateException("Duplicate library " + library.getName());
            }
            writer.writeNestedLibrary(destination, library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZip(File file) {
        boolean bl;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            bl = this.isZip(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (int i = 0; i < ZIP_FILE_HEADER.length; ++i) {
            if (inputStream.read() == ZIP_FILE_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    private Manifest buildManifest(JarFile source) throws IOException {
        Manifest manifest = source.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
        }
        manifest = new Manifest(manifest);
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Solon-Jar-Build-Tool", "Solon-Jar-Plugin");
        manifest.getMainAttributes().putValue("Start-Class", this.mainClass);
        manifest.getMainAttributes().putValue("Main-Class", "org.noear.solon.loader.JarLauncher");
        return manifest;
    }

    private void renameFile(File file, File dest) {
        if (!file.renameTo(dest)) {
            throw new IllegalStateException("Unable to rename '" + file + "' to '" + dest + "'");
        }
    }

    private static final class RenamingEntryTransformer
    implements JarWriter.EntryTransformer {
        private final String namePrefix;

        private RenamingEntryTransformer(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public JarEntry transform(JarEntry entry) {
            if (entry.getName().equals("META-INF/INDEX.LIST")) {
                return null;
            }
            if (entry.getName().startsWith("META-INF/") && !entry.getName().equals("META-INF/aop.xml") || entry.getName().startsWith("BOOT-INF/")) {
                return entry;
            }
            JarEntry renamedEntry = new JarEntry(this.namePrefix + entry.getName());
            renamedEntry.setTime(entry.getTime());
            renamedEntry.setSize(entry.getSize());
            renamedEntry.setMethod(entry.getMethod());
            if (entry.getComment() != null) {
                renamedEntry.setComment(entry.getComment());
            }
            renamedEntry.setCompressedSize(entry.getCompressedSize());
            renamedEntry.setCrc(entry.getCrc());
            this.setCreationTimeIfPossible(entry, renamedEntry);
            if (entry.getExtra() != null) {
                renamedEntry.setExtra(entry.getExtra());
            }
            this.setLastAccessTimeIfPossible(entry, renamedEntry);
            this.setLastModifiedTimeIfPossible(entry, renamedEntry);
            return renamedEntry;
        }

        private void setCreationTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getCreationTime() != null) {
                    target.setCreationTime(source.getCreationTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        private void setLastAccessTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getLastAccessTime() != null) {
                    target.setLastAccessTime(source.getLastAccessTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        private void setLastModifiedTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getLastModifiedTime() != null) {
                    target.setLastModifiedTime(source.getLastModifiedTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }
}

