/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.loader;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import org.noear.solon.loader.LaunchedURLClassLoader;
import org.noear.solon.loader.MainMethodRunner;
import org.noear.solon.loader.archive.Archive;
import org.noear.solon.loader.archive.ExplodedArchive;
import org.noear.solon.loader.archive.JarFileArchive;
import org.noear.solon.loader.jar.JarFile;

public abstract class Launcher {
    private static final String JAR_MODE_LAUNCHER = "org.noear.solon.loader.jarmode.JarModeLauncher";

    protected void launch(String[] args) throws Exception {
        if (!this.isExploded()) {
            JarFile.registerUrlProtocolHandler();
        }
        ClassLoader classLoader = this.createClassLoader(this.getClassPathArchivesIterator());
        String jarMode = System.getProperty("jarmode");
        String launchClass = jarMode != null && !jarMode.isEmpty() ? JAR_MODE_LAUNCHER : this.getMainClass();
        this.launch(args, launchClass, classLoader);
    }

    protected ClassLoader createClassLoader(Iterator<Archive> archives) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>(50);
        while (archives.hasNext()) {
            urls.add(archives.next().getUrl());
        }
        return this.createClassLoader(urls.toArray(new URL[0]));
    }

    protected ClassLoader createClassLoader(URL[] urls) throws Exception {
        return new LaunchedURLClassLoader(this.isExploded(), this.getArchive(), urls, this.getClass().getClassLoader());
    }

    protected void launch(String[] args, String launchClass, ClassLoader classLoader) throws Exception {
        Thread.currentThread().setContextClassLoader(classLoader);
        this.createMainMethodRunner(launchClass, args, classLoader).run();
    }

    protected MainMethodRunner createMainMethodRunner(String mainClass, String[] args, ClassLoader classLoader) {
        return new MainMethodRunner(mainClass, args);
    }

    protected abstract String getMainClass() throws Exception;

    protected abstract Iterator<Archive> getClassPathArchivesIterator() throws Exception;

    protected final Archive createArchive() throws Exception {
        String path;
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource != null ? codeSource.getLocation().toURI() : null;
        String string = path = location != null ? location.getSchemeSpecificPart() : null;
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        File root = new File(path);
        if (!root.exists()) {
            throw new IllegalStateException("Unable to determine code source archive from " + root);
        }
        return root.isDirectory() ? new ExplodedArchive(root) : new JarFileArchive(root);
    }

    protected boolean isExploded() {
        return false;
    }

    protected Archive getArchive() {
        return null;
    }
}

