/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.noear.solon.maven.plugin.ClassesMove;
import org.noear.solon.maven.plugin.CopyLoader;
import org.noear.solon.maven.plugin.Repackager;
import org.noear.solon.maven.plugin.tools.tool.ArtifactsLibraries;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class RepackageMojo
extends AbstractMojo {
    @Parameter(required=false)
    private String mainClass;
    @Parameter(readonly=false)
    private String jvmArguments;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter
    private String classifier;
    @Component
    private MavenProject project;
    private Log logger = this.getLog();

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassesMove.change(this.project.getArtifact().getFile());
        this.repackage();
        try {
            CopyLoader.start(this.getTargetFile());
        }
        catch (Exception e) {
            throw new MojoExecutionException("write loader exception", e);
        }
    }

    private void repackage() throws MojoExecutionException, MojoFailureException {
        try {
            File sourceFile = this.project.getArtifact().getFile();
            Repackager repackager = new Repackager(sourceFile, this.logger, this.mainClass);
            File target = this.getTargetFile();
            Set artifacts = this.project.getArtifacts();
            ArtifactsLibraries libraries = new ArtifactsLibraries(artifacts, Collections.emptyList(), this.getLog());
            repackager.repackage(target, libraries);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private File getTargetFile() {
        String classifier;
        String string = classifier = this.classifier != null ? this.classifier.trim() : "";
        if (classifier.length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        String name = this.finalName + classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension();
        return new File(this.outputDirectory, name);
    }
}

