/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin.loader.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.noear.solon.maven.plugin.loader.data.RandomAccessData;

public class ByteArrayRandomAccessData
implements RandomAccessData {
    private final byte[] bytes;
    private final long offset;
    private final long length;

    public ByteArrayRandomAccessData(byte[] bytes) {
        this(bytes, 0L, bytes == null ? 0 : bytes.length);
    }

    public ByteArrayRandomAccessData(byte[] bytes, long offset, long length) {
        this.bytes = bytes == null ? new byte[]{} : bytes;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public InputStream getInputStream(RandomAccessData.ResourceAccess access) {
        return new ByteArrayInputStream(this.bytes, (int)this.offset, (int)this.length);
    }

    @Override
    public RandomAccessData getSubsection(long offset, long length) {
        return new ByteArrayRandomAccessData(this.bytes, this.offset + offset, length);
    }

    @Override
    public long getSize() {
        return this.length;
    }
}

