/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class CopyLoader {
    static String path;
    static String name;
    static String tempName;

    public static void start(File file) throws Exception {
        name = file.getName();
        tempName = UUID.randomUUID() + ".jar";
        path = file.getAbsolutePath().replace(name, "");
        CopyLoader.setLoader();
        CopyLoader.organizeFiles();
    }

    private static void organizeFiles() {
        new File(path + name).delete();
        new File(path + tempName).renameTo(new File(path + name));
    }

    private static void setLoader() throws IOException {
        try {
            ProtectionDomain protectionDomain = CopyLoader.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource == null ? null : codeSource.getLocation().toURI();
            String mavenPluginJarPath = location == null ? null : location.getSchemeSpecificPart();
            JarFile jarfile = new JarFile(mavenPluginJarPath);
            JarFile targetJarfile = new JarFile(path + name);
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(path + tempName));
            Enumeration<JarEntry> entries = jarfile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().contains("org/noear/solon/maven/plugin/loader/") || !jarEntry.getName().endsWith(".class")) continue;
                jarOutputStream.putNextEntry(jarEntry);
                byte[] bytes = CopyLoader.toByteArray(jarfile.getInputStream(jarEntry));
                jarOutputStream.write(bytes);
            }
            Enumeration<JarEntry> targetEntries = targetJarfile.entries();
            while (targetEntries.hasMoreElements()) {
                JarEntry entry = targetEntries.nextElement();
                InputStream entryInputStream = targetJarfile.getInputStream(entry);
                jarOutputStream.putNextEntry(entry);
                jarOutputStream.write(CopyLoader.toByteArray(entryInputStream));
            }
            jarOutputStream.flush();
            jarOutputStream.close();
            targetJarfile.close();
            jarfile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }
}

