/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.appender;

import java.io.PrintWriter;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.core.util.JavaUtil;
import org.noear.solon.logging.appender.AppenderSimple;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.event.LogEvent;

public abstract class OutputStreamAppender
extends AppenderSimple {
    protected PrintWriter out = null;
    protected final ReentrantLock SYNC_LOCK = new ReentrantLock(true);

    protected void setOutput(PrintWriter writer) {
        if (writer == null) {
            return;
        }
        PrintWriter outOld = this.out;
        this.out = writer;
        if (outOld != null) {
            outOld.flush();
            outOld.close();
        }
    }

    @Override
    public void append(LogEvent logEvent) {
        if (this.out == null) {
            return;
        }
        super.append(logEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendDo(Level level, String title, Object content) {
        this.SYNC_LOCK.lock();
        try {
            switch (level) {
                case ERROR: {
                    this.redln(title);
                    break;
                }
                case WARN: {
                    this.yellowln(title);
                    break;
                }
                case DEBUG: {
                    this.blueln(title);
                    break;
                }
                case TRACE: {
                    this.purpleln(title);
                    break;
                }
                default: {
                    this.greenln(title);
                }
            }
            if (content instanceof String) {
                this.out.println(content);
            } else {
                this.out.println(ONode.serialize((Object)content, (Feature[])new Feature[0]));
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    protected void redln(Object txt) {
        this.colorln("\u001b[31m", txt);
    }

    protected void blueln(Object txt) {
        this.colorln("\u001b[34m", txt);
    }

    protected void greenln(Object txt) {
        this.colorln("\u001b[32m", txt);
    }

    protected void purpleln(Object txt) {
        this.colorln("\u001b[35m", txt);
    }

    protected void yellowln(Object txt) {
        this.colorln("\u001b[33m", txt);
    }

    protected void colorln(String color, Object s) {
        if (JavaUtil.IS_WINDOWS) {
            this.out.println(s);
        } else {
            this.out.println(color + s);
            this.out.print("\u001b[0m");
        }
    }
}

