/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.FactoryManager;
import org.slf4j.spi.MDCAdapter;

public class SolonMDCAdapter
implements MDCAdapter {
    private static ThreadLocal<Map<String, Deque<String>>> _threadMapOfStacks;
    private static ThreadLocal<Map<String, String>> _threadMap;

    private static ThreadLocal<Map<String, String>> threadMap() {
        if (_threadMap == null) {
            Utils.locker().lock();
            try {
                if (_threadMap == null) {
                    _threadMap = FactoryManager.getGlobal().newThreadLocal(SolonMDCAdapter.class, false);
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return _threadMap;
    }

    private static ThreadLocal<Map<String, Deque<String>>> threadMapOfStacks() {
        if (_threadMapOfStacks == null) {
            Utils.locker().lock();
            try {
                if (_threadMapOfStacks == null) {
                    _threadMapOfStacks = FactoryManager.getGlobal().newThreadLocal(SolonMDCAdapter.class, false);
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return _threadMapOfStacks;
    }

    public void put(String key, String val) {
        Map<String, String> ht = SolonMDCAdapter.threadMap().get();
        if (ht == null) {
            ht = new LinkedHashMap<String, String>();
            SolonMDCAdapter.threadMap().set(ht);
        }
        ht.put(key, val);
    }

    public String get(String key) {
        Map<String, String> ht = SolonMDCAdapter.threadMap().get();
        if (ht != null) {
            return ht.get(key);
        }
        return null;
    }

    public void remove(String key) {
        Map<String, String> ht = SolonMDCAdapter.threadMap().get();
        if (ht != null) {
            ht.remove(key);
        }
    }

    public void clear() {
        SolonMDCAdapter.threadMap().set(null);
    }

    public Map<String, String> getCopyOfContextMap() {
        Map<String, String> map = SolonMDCAdapter.threadMap().get();
        if (map != null) {
            return new LinkedHashMap<String, String>(map);
        }
        return map;
    }

    public void setContextMap(Map<String, String> map) {
        SolonMDCAdapter.threadMap().set(map);
    }

    public void pushByKey(String key, String value) {
        if (key != null) {
            Deque<String> deque;
            Map<String, Deque<String>> map = this.threadMapOfStacks().get();
            if (map == null) {
                map = new HashMap<String, Deque<String>>();
                this.threadMapOfStacks().set(map);
            }
            if ((deque = map.get(key)) == null) {
                deque = new ArrayDeque<String>();
            }
            deque.push(value);
            map.put(key, deque);
        }
    }

    public String popByKey(String key) {
        if (key == null) {
            return null;
        }
        Map<String, Deque<String>> map = SolonMDCAdapter.threadMapOfStacks().get();
        if (map == null) {
            return null;
        }
        Deque<String> deque = map.get(key);
        return deque == null ? null : deque.pop();
    }

    public Deque<String> getCopyOfDequeByKey(String key) {
        if (key == null) {
            return null;
        }
        Map<String, Deque<String>> map = SolonMDCAdapter.threadMapOfStacks().get();
        if (map == null) {
            return null;
        }
        Deque<String> deque = map.get(key);
        return deque == null ? null : new ArrayDeque<String>(deque);
    }

    public void clearDequeByKey(String key) {
        Deque<String> deque;
        Map<String, Deque<String>> map;
        if (key != null && (map = SolonMDCAdapter.threadMapOfStacks().get()) != null && (deque = map.get(key)) != null) {
            deque.clear();
        }
    }
}

