/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health;

import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.health.HealthCheckResult;
import org.noear.solon.health.HealthChecker;

public class HealthHandler
implements Handler {
    public static final String HANDLER_PATH = "/healthz";
    private static final HealthHandler instance = new HealthHandler();
    private static final Options options = Options.of((Feature[])new Feature[0]).addFeatures(new Feature[]{Feature.Write_EnumUsingName});

    public static HealthHandler getInstance() {
        return instance;
    }

    public void handle(Context ctx) throws Throwable {
        HealthCheckResult result = HealthChecker.check();
        switch (result.getStatus()) {
            case DOWN: {
                ctx.status(503);
                break;
            }
            case ERROR: {
                ctx.status(500);
                break;
            }
            default: {
                ctx.status(200);
            }
        }
        ctx.outputAsJson(ONode.serialize((Object)result, (Options)options));
    }
}

