/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health.detector.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.health.detector.AbstractDetector;
import org.noear.solon.health.detector.util.SizeUtil;

public class JvmMemoryDetector
extends AbstractDetector {
    @Override
    public String getName() {
        return "jvm";
    }

    @Override
    public Map<String, Object> getInfo() {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        Runtime run = Runtime.getRuntime();
        long max = run.maxMemory();
        long total = run.totalMemory();
        long free = run.freeMemory();
        long used = total - free;
        long usable = max - used;
        if (max > 0L) {
            float ratio = (float)used * 100.0f / (float)max;
            info.put("ratio", Float.valueOf(ratio));
        }
        info.put("total", SizeUtil.formatByteSize(total));
        info.put("used", SizeUtil.formatByteSize(used));
        info.put("usable", SizeUtil.formatByteSize(usable));
        info.put("free", SizeUtil.formatByteSize(free));
        return info;
    }
}

