/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.guidance.PropertiesGuidance;
import org.noear.solon.expression.guidance.ReturnGuidance;
import org.noear.solon.expression.snel.SnEL;
import org.noear.solon.expression.snel.TemplateFragment;
import org.noear.solon.expression.snel.TemplateMarker;

public class TemplateNode
implements Expression<String> {
    private final List<TemplateFragment> fragments;
    private TemplateFragment constantFragment;

    public TemplateNode(List<TemplateFragment> fragments) {
        this.fragments = fragments;
        if (fragments.size() == 1 && fragments.get(0).getMarker() == TemplateMarker.TEXT) {
            this.constantFragment = fragments.get(0);
        }
    }

    @Override
    public String eval(Function context) {
        boolean allowReturnNull = false;
        boolean allowPropertyDefault = true;
        boolean allowPropertyNesting = false;
        boolean allowTextAsProperty = false;
        Object propsObject = null;
        if (context instanceof ReturnGuidance) {
            allowReturnNull = ((ReturnGuidance)((Object)context)).allowReturnNull();
        }
        if (context instanceof PropertiesGuidance) {
            PropertiesGuidance tmp = (PropertiesGuidance)((Object)context);
            propsObject = tmp.getProperties();
            allowPropertyDefault = tmp.allowPropertyDefault();
            allowPropertyNesting = tmp.allowPropertyNesting();
            allowTextAsProperty = tmp.allowTextAsProperty();
        }
        if (propsObject == null) {
            propsObject = context;
        }
        if (this.constantFragment != null) {
            if (allowTextAsProperty) {
                String value = this.evalProps(this.constantFragment, propsObject, allowPropertyDefault, allowPropertyNesting, context, null);
                if (allowReturnNull && value == null) {
                    return null;
                }
                return value;
            }
            return this.constantFragment.getContent();
        }
        StringBuilder result = new StringBuilder();
        for (TemplateFragment fragment : this.fragments) {
            Object value;
            if (fragment.getMarker() == TemplateMarker.TEXT) {
                if (allowTextAsProperty) {
                    value = this.evalProps(fragment, propsObject, allowPropertyDefault, allowPropertyNesting, context, result);
                    if (!allowReturnNull || value != null) continue;
                    return null;
                }
                result.append(fragment.getContent());
                continue;
            }
            if (fragment.getMarker() == TemplateMarker.PROPERTIES) {
                value = this.evalProps(fragment, propsObject, allowPropertyDefault, allowPropertyNesting, context, result);
            } else {
                value = SnEL.eval(fragment.getContent(), context);
                result.append(value);
            }
            if (!allowReturnNull || value != null) continue;
            return null;
        }
        return result.toString();
    }

    private String evalProps(TemplateFragment fragment, Object propsObject, boolean allowPropertyDefault, boolean allowPropertyNesting, Function context, StringBuilder result) {
        String value = this.getProps(fragment, propsObject, allowPropertyDefault);
        if (value != null && allowPropertyNesting) {
            value = SnEL.evalTmpl(value, context);
        }
        if (value != null && result != null) {
            result.append(value);
        }
        return value;
    }

    private String getProps(TemplateFragment expr, Object propsObject, boolean allowPropertyDefault) {
        String value = null;
        if (propsObject instanceof Properties) {
            value = ((Properties)propsObject).getProperty(expr.getPropertyKey());
        } else if (propsObject instanceof Function) {
            Object tmp = ((Function)propsObject).apply(expr.getPropertyKey());
            if (tmp != null) {
                value = String.valueOf(tmp);
            }
        } else {
            throw new IllegalArgumentException("Unsupported properties type: " + propsObject.getClass());
        }
        if (value == null && allowPropertyDefault) {
            return expr.getPropertyDef();
        }
        return value;
    }
}

