/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.snel.ComparisonOp;
import org.noear.solon.expression.snel.TemplateNode;

public class ComparisonNode
implements Expression<Boolean> {
    private final ComparisonOp operator;
    private final Expression left;
    private final Expression right;
    private final boolean leftIsTemplate;
    private final boolean rightIsTemplate;

    public ComparisonOp getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public ComparisonNode(ComparisonOp operator, Expression left, Expression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
        this.leftIsTemplate = left instanceof TemplateNode;
        this.rightIsTemplate = right instanceof TemplateNode;
    }

    @Override
    public Boolean eval(Function context) {
        Object leftValue = this.left.eval(context);
        Object rightValue = this.right.eval(context);
        if (this.leftIsTemplate) {
            leftValue = this.getOptimizeValue(leftValue, rightValue);
        } else if (this.rightIsTemplate) {
            rightValue = this.getOptimizeValue(rightValue, leftValue);
        }
        if (this.operator == ComparisonOp.eq) {
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
            }
            return Objects.equals(leftValue, rightValue);
        }
        if (this.operator == ComparisonOp.neq) {
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() != ((Number)rightValue).doubleValue();
            }
            return !Objects.equals(leftValue, rightValue);
        }
        if (this.operator == ComparisonOp.in) {
            if (rightValue instanceof Collection) {
                return ((Collection)rightValue).contains(leftValue);
            }
            return false;
        }
        if (this.operator == ComparisonOp.nin) {
            if (rightValue instanceof Collection) {
                return !((Collection)rightValue).contains(leftValue);
            }
            return false;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        switch (this.operator) {
            case gt: {
                return ((Number)leftValue).doubleValue() > ((Number)rightValue).doubleValue();
            }
            case gte: {
                return ((Number)leftValue).doubleValue() >= ((Number)rightValue).doubleValue();
            }
            case lt: {
                return ((Number)leftValue).doubleValue() < ((Number)rightValue).doubleValue();
            }
            case lte: {
                return ((Number)leftValue).doubleValue() <= ((Number)rightValue).doubleValue();
            }
            case lk: {
                return leftValue.toString().contains(rightValue.toString());
            }
            case nlk: {
                return !leftValue.toString().contains(rightValue.toString());
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    protected Object getOptimizeValue(Object val, Object ref) {
        if (val instanceof String) {
            if (ref instanceof Boolean) {
                return this.getBoolean((String)val, false);
            }
            if (ref instanceof Number) {
                return this.getNumber((String)val, 0L);
            }
        }
        return val;
    }

    protected boolean getBoolean(String value, boolean defaultValue) {
        if (value == null && value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    protected Number getNumber(String value, Number defaultValue) {
        if (value == null && value.length() == 0) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public String toString() {
        return "(" + this.left + " " + this.operator.getCode() + " " + this.right + ")";
    }
}

