/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.context.StandardContext;
import org.noear.solon.expression.snel.SnEL;
import org.noear.solon.expression.snel.TemplateFragment;

public class TemplateNode
implements Expression<String> {
    private List<TemplateFragment> fragments;

    public TemplateNode(List<TemplateFragment> fragments) {
        this.fragments = fragments;
    }

    @Override
    public String eval(Function context) {
        StringBuilder result = new StringBuilder();
        for (TemplateFragment fragment : this.fragments) {
            if (fragment.isEvaluable()) {
                Object value = fragment.getMarker() == 36 ? this.getProps(fragment.getContent(), context) : SnEL.eval(fragment.getContent(), context);
                result.append(value);
                continue;
            }
            result.append(fragment.getContent());
        }
        return result.toString();
    }

    private String getProps(String expr, Function context) {
        int colonIdx;
        Object props = context.apply("$PROPS");
        if (props == null) {
            if (context instanceof StandardContext) {
                props = ((StandardContext)context).properties();
            }
            if (props == null) {
                throw new IllegalArgumentException("Missing property '$PROPS'");
            }
        }
        String key = (colonIdx = expr.lastIndexOf(58)) < 0 ? expr : expr.substring(0, colonIdx);
        String def = colonIdx < 0 ? "" : expr.substring(colonIdx + 1);
        String value = null;
        if (props instanceof Properties) {
            value = ((Properties)props).getProperty(key);
        } else if (props instanceof Function) {
            value = String.valueOf(((Function)props).apply(key));
        } else {
            throw new IllegalArgumentException("Unsupported props type: " + props.getClass());
        }
        if (value == null) {
            return def;
        }
        return value;
    }
}

