/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.Arrays;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.snel.ComparisonNode;
import org.noear.solon.expression.snel.ComparisonOp;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.LogicalNode;
import org.noear.solon.expression.snel.LogicalOp;
import org.noear.solon.expression.snel.VariableNode;

public class ConditionBuilder {
    public LogicalNode and(Expression<Boolean> left, Expression<Boolean> right) {
        return new LogicalNode(LogicalOp.and, left, right);
    }

    public LogicalNode or(Expression<Boolean> left, Expression<Boolean> right) {
        return new LogicalNode(LogicalOp.or, left, right);
    }

    public LogicalNode not(Expression<Boolean> left) {
        return new LogicalNode(LogicalOp.not, left, null);
    }

    public ComparisonNode lt(String field, Number value) {
        return new ComparisonNode(ComparisonOp.lt, new VariableNode(field), new ConstantNode(value));
    }

    public ComparisonNode lte(String field, Number value) {
        return new ComparisonNode(ComparisonOp.lte, new VariableNode(field), new ConstantNode(value));
    }

    public ComparisonNode gt(String field, Number value) {
        return new ComparisonNode(ComparisonOp.gt, new VariableNode(field), new ConstantNode(value));
    }

    public ComparisonNode gte(String field, Number value) {
        return new ComparisonNode(ComparisonOp.gte, new VariableNode(field), new ConstantNode(value));
    }

    public ComparisonNode eq(String field, Object value) {
        return new ComparisonNode(ComparisonOp.eq, new VariableNode(field), new ConstantNode(value));
    }

    public ComparisonNode neq(String field, Object value) {
        return new ComparisonNode(ComparisonOp.neq, new VariableNode(field), new ConstantNode(value));
    }

    public ComparisonNode in(String field, Object ... values) {
        return new ComparisonNode(ComparisonOp.in, new VariableNode(field), new ConstantNode(Arrays.asList(values)));
    }
}

