/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Parser;
import org.noear.solon.expression.exception.CompilationException;
import org.noear.solon.expression.snel.TemplateFragment;
import org.noear.solon.expression.snel.TemplateNode;

public class SnelTemplateParser
implements Parser<String> {
    private static final SnelTemplateParser INSTANCE = new SnelTemplateParser();
    private final Map<String, Expression<String>> exprCached = new ConcurrentHashMap<String, Expression<String>>();
    private static final int BUFFER_SIZE = 1024;
    private static final char MARK_START1 = '#';
    private static final char MARK_START2 = '$';
    private static final char MARK_BRACE_OPEN = '{';
    private static final char MARK_BRACE_CLOSE = '}';

    public static SnelTemplateParser getInstance() {
        return INSTANCE;
    }

    @Override
    public Expression<String> parse(String expr, boolean cached) {
        if (cached) {
            return this.exprCached.computeIfAbsent(expr, this::parseDo);
        }
        return this.parseDo(expr);
    }

    protected Expression<String> parseDo(String expr) {
        return this.parseDo(new StringReader(expr));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Expression<String> parseDo(Reader reader) {
        try (BufferedReader br = SnelTemplateParser.wrapReader(reader);){
            int readCount;
            ParserState state = new ParserState(br);
            ArrayList<TemplateFragment> fragments = new ArrayList<TemplateFragment>(64);
            char[] buffer = new char[1024];
            while ((readCount = br.read(buffer)) != -1) {
                this.parseBuffer(buffer, readCount, state, fragments);
            }
            this.completeParsing(state, fragments);
            TemplateNode templateNode = new TemplateNode(fragments);
            return templateNode;
        }
        catch (IOException e) {
            throw new CompilationException("Compilation failed", e);
        }
    }

    private void parseBuffer(char[] buffer, int length, ParserState state, List<TemplateFragment> fragments) {
        int i = 0;
        while (i < length) {
            if (state.inExpression) {
                i = this.processExpression(buffer, i, length, state, fragments);
                continue;
            }
            i = this.processText(buffer, i, length, state, fragments);
        }
    }

    private int processText(char[] buffer, int index, int length, ParserState state, List<TemplateFragment> fragments) {
        int start = index;
        while (index < length) {
            int ch = buffer[index];
            if ((ch == 35 || ch == 36) && index + 1 < length) {
                state.marker = ch;
                if (buffer[index + 1] == '{') {
                    this.flushText(state, fragments, buffer, start, index);
                    state.inExpression = true;
                    return index + 2;
                }
                ++index;
            }
            ++index;
        }
        state.textBuffer.append(buffer, start, index - start);
        return index;
    }

    private int processExpression(char[] buffer, int index, int length, ParserState state, List<TemplateFragment> fragments) {
        int start = index;
        while (index < length) {
            if (buffer[index] == '}') {
                state.exprBuffer.append(buffer, start, index - start);
                fragments.add(new TemplateFragment(true, state.marker, state.exprBuffer.toString()));
                state.exprBuffer.setLength(0);
                state.inExpression = false;
                return index + 1;
            }
            ++index;
        }
        state.exprBuffer.append(buffer, start, index - start);
        return index;
    }

    private void flushText(ParserState state, List<TemplateFragment> fragments, char[] buffer, int start, int end) {
        if (start < end) {
            state.textBuffer.append(buffer, start, end - start);
        }
        if (state.textBuffer.length() > 0) {
            fragments.add(new TemplateFragment(false, 0, state.textBuffer.toString()));
            state.textBuffer.setLength(0);
        }
    }

    private void completeParsing(ParserState state, List<TemplateFragment> fragments) {
        if (state.inExpression) {
            fragments.add(new TemplateFragment(false, 0, "#{" + state.exprBuffer));
        }
        this.flushText(state, fragments, new char[0], 0, 0);
    }

    private static BufferedReader wrapReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    private static class ParserState {
        final StringBuilder textBuffer = new StringBuilder(256);
        final StringBuilder exprBuffer = new StringBuilder(64);
        boolean inExpression;
        int marker;
        final BufferedReader reader;

        ParserState(BufferedReader reader) {
            this.reader = reader;
        }
    }
}

