/*
 * Decompiled with CFR 0.152.
 */
package com.layjava.docs.javadoc.solon;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.layjava.docs.javadoc.solon.OpenApi2Builder;
import com.layjava.docs.javadoc.solon.util.JsonUtil;
import io.swagger.models.Swagger;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.models.ApiGroupResource;
import org.noear.solon.docs.util.BasicAuthUtil;

public class OpenApi2Utils {
    public static String getApiGroupResourceJson() throws IOException {
        return OpenApi2Utils.getApiGroupResourceJson("/swagger/v2");
    }

    public static String getApiGroupResourceJson(String resourceUri) throws IOException {
        List list = Solon.context().getWrapsOfType(DocDocket.class);
        List resourceList = list.stream().filter(bw -> Utils.isNotEmpty((String)bw.name())).map(bw -> {
            String group = bw.name();
            String groupName = ((DocDocket)bw.raw()).groupName();
            String url = resourceUri + "?group=" + group;
            return new ApiGroupResource(groupName, "2.0", url);
        }).collect(Collectors.toList());
        return JsonUtil.toJson(resourceList);
    }

    public static String getApiJson(Context ctx, String group) throws IOException {
        List docDockets = Solon.context().getBeansOfType(DocDocket.class);
        if (CollUtil.isEmpty((Collection)docDockets)) {
            return "";
        }
        if (StrUtil.isBlank((CharSequence)group)) {
            group = ((DocDocket)docDockets.get(0)).groupName();
        }
        String finalGroup = group;
        DocDocket docket = docDockets.stream().filter(d -> d.groupName().equals(finalGroup)).findFirst().orElse((DocDocket)docDockets.get(0));
        if (!BasicAuthUtil.basicAuth((Context)ctx, (DocDocket)docket)) {
            BasicAuthUtil.response401((Context)ctx);
            return null;
        }
        if (!docket.globalResponseCodes().containsKey(200)) {
            docket.globalResponseCodes().put(200, "");
        }
        Swagger swagger = new OpenApi2Builder(docket).build();
        return JsonUtil.toJson(swagger);
    }
}

