/*
 * Decompiled with CFR 0.152.
 */
package com.layjava.docs.javadoc.solon;

import cn.hutool.core.collection.CollUtil;
import com.layjava.docs.javadoc.solon.properties.DocketProperty;
import com.layjava.docs.javadoc.solon.properties.DocsProperty;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.models.ApiContact;
import org.noear.solon.docs.models.ApiInfo;

@Configuration
public class DocDocketConfig {
    private static final String PREFIX_NAME = "com.layjava.docs.javadoc.solon.plugin-";
    @Inject(value="${solon}")
    private DocketProperty docketProperty;
    @Inject(value="${solon.docs}")
    private DocsProperty docsProperty;

    @Bean
    public void buildDocDocket() {
        if (this.docketProperty == null) {
            this.docketProperty = new DocketProperty();
        }
        if (this.docsProperty != null) {
            this.docketProperty.getDocs().add(this.docsProperty);
        }
        if (CollUtil.isEmpty(this.docketProperty.getDocs())) {
            return;
        }
        this.docketProperty.getDocs().stream().filter(docsProperty -> Boolean.TRUE.equals(docsProperty.isEnabled())).forEach(docsProperty -> {
            DocDocket docDocket = new DocDocket();
            docDocket.groupName(docsProperty.getGroupName());
            ApiInfo apiInfo = new ApiInfo().title(docsProperty.getTitle()).description(docsProperty.getDescription()).version(docsProperty.getVersion());
            if (docsProperty.getContact() != null) {
                apiInfo.contact(new ApiContact().name(docsProperty.getContact().getName()).url(docsProperty.getContact().getUrl()).email(docsProperty.getContact().getEmail()));
            }
            docDocket.info(apiInfo).apis(docsProperty.getPackageName()).globalResult(docsProperty.getGlobalData()).globalResponseInData(docsProperty.getGlobalResponseInData().booleanValue()).schemes(docsProperty.getSchemes().toArray(new String[0]));
            BeanWrap beanWrap = Solon.context().wrap(DocDocket.class, (Object)docDocket);
            Solon.context().putWrap(PREFIX_NAME + docsProperty.getGroupName(), beanWrap);
        });
    }
}

